#if !defined( __CSTATSDLG_H )
#define __CSTATSDLG_H
////////////////////////////////////////////////////////////////////////////////
#if !defined( __CCOMMSERVERTHREAD_H )
#include "cCommServerThread.h"
#endif
#if !defined( __CDIALOGBOX_H )
#include "cDialogBox.h"
#endif
#include <commctrl.h>
#include <stdio.h>
#include "resource.h"
////////////////////////////////////////////////////////////////////////////////

class cStatsDlg : public cDialogBox {
protected:
  cCommServerThread   *d_pServer;

  virtual LRESULT OnInitDialog( WPARAM wparam, LPARAM lparam ) {
    CenterDlg();
    UpdateData();

    return cDialogBox::OnInitDialog( wparam, lparam );
  }

  virtual LRESULT OnDestroy( WPARAM wparam, LPARAM lparam ) {
    return 0;
  }

  void CenterDlg() {
    RECT WinRect, TabRect;

    GetWindowRect( GetDlgItem( GetParent( d_hwnd ), IDC_TAB1 ), &TabRect );
    GetWindowRect( GetParent( d_hwnd ), &WinRect );

    WinRect.left = TabRect.left - WinRect.left;
    WinRect.top = TabRect.top - WinRect.top - GetSystemMetrics( SM_CYCAPTION );

    TabCtrl_AdjustRect( GetDlgItem( GetParent( d_hwnd ), IDC_TAB1 ), FALSE, &WinRect );

    SetWindowPos( d_hwnd, HWND_TOP, WinRect.left, WinRect.top, 0, 0, SWP_NOSIZE );
  }

public:
  cStatsDlg() : cDialogBox() {}
  virtual ~cStatsDlg() {}

  void SetCommServerThread( cCommServerThread *pServer ) { d_pServer = pServer; }

  virtual void UpdateData() {
    if( !d_active ) return;

    DWORD startTime;
    char  time[ 32 ];

    if( !d_pServer || !d_pServer->GetWorking() ) {
      SetDlgItemText( d_hwnd, IDC_TIMEELAPSED, "000:00:00" );
      SetDlgItemText( d_hwnd, IDC_TIMEELAPSED, "000:00:00" );
    } else {
      startTime = d_pServer->GetStartTime() / 1000;
      sprintf( time, "%03d:%02d:%02d", startTime / 3600, ( startTime / 60 ) % 60, startTime % 60 );
      SetDlgItemText( d_hwnd, IDC_TIMESTARTED, time );
      startTime = ( GetTickCount() / 1000 ) - startTime;
      sprintf( time, "%03d:%02d:%02d", startTime / 3600, ( startTime / 60 ) % 60, startTime % 60 );
      SetDlgItemText( d_hwnd, IDC_TIMEELAPSED, time );
    }
  }
};


#endif

