#if !defined( __CNETWORKSERVER_H )
#define __CNETWORKSERVER_H
////////////////////////////////////////////////////////////////////////////////
#if !defined( __CCOMMSERVERTHREAD_H )
#include "cCommServerThread.h"
#endif
#if !defined( __CDIALOGBOX_H )
#include "cDialogBox.h"
#endif
#if !defined( __CCONNECTDLG_H )
#include "cConnectDlg.h"
#endif
#if !defined( __CCLIENTSDLG_H )
#include "cClientsDlg.h"
#endif
#if !defined( __CSTATSDLG_H )
#include "cStatsDlg.h"
#endif
#if !defined( __CABOUTDLG_H )
#include "cAboutDlg.h"
#endif
////////////////////////////////////////////////////////////////////////////////
#define NS_SNAPTIME       80  // 80 milliseconds between snaps or 25 every 2 seconds
////////////////////////////////////////////////////////////////////////////////

class cNetworkServer : public cDialogBox {
protected:
  cCommServerThread d_serverThread;
  DWORD             d_lastFrame, d_lastSnap;
  int               d_quit;

  HWND              d_tabControl;
  cDialogBox        *d_pCurrTab;
  cStatsDlg         d_statsDlg;
  cAboutDlg         d_aboutDlg;
  cConnectDlg       d_connectDlg;
  cClientsDlg       d_clientsDlg;

  virtual LRESULT OnInitDialog( WPARAM wparam, LPARAM lparam );
  virtual LRESULT OnDestroy( WPARAM wparam, LPARAM lparam );
  virtual LRESULT OnCommand( WPARAM wparam, LPARAM lparam );
  virtual LRESULT OnNotify( WPARAM wparam, LPARAM lparam );
  virtual LRESULT OnOther( unsigned int msg, WPARAM wparam, LPARAM lparam );
  virtual LRESULT OnClose( WPARAM wparam, LPARAM lparam );

  void OnCancel();
  void TabChange();

public:
  cNetworkServer();
  virtual ~cNetworkServer();

  int Startup( HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpCmdLine, int nCmdShow );
  int Shutdown();

  int MainLoop();
  int Update();
};


#endif

