/* NETWORK SERVER: cNetworkServer.cpp
 * Created 23/06/99 Dan Royer
 * Main dialog for the network server
 */
#if !defined( __CNETWORKSERVER_H )
#include "cNetworkServer.h"
#endif
#include <commctrl.h>
#include "resource.h"
////////////////////////////////////////////////////////////////////////////////

cNetworkServer::cNetworkServer() : cDialogBox() {
  d_quit = 0;
}


cNetworkServer::~cNetworkServer() {}
////////////////////////////////////////////////////////////////////////////////

LRESULT cNetworkServer::OnInitDialog( WPARAM wparam, LPARAM lparam ) {
  TC_ITEM TabItem;

  d_tabControl = GetDlgItem( d_hwnd, IDC_TAB1 );
  d_pCurrTab = NULL;

  TabItem.mask    = TCIF_TEXT | TCIF_IMAGE;
  TabItem.iImage  = -1;
  TabItem.pszText = "Connection";
  TabCtrl_InsertItem( d_tabControl, 0, &TabItem );
  TabItem.pszText = "Clients";
  TabCtrl_InsertItem( d_tabControl, 1, &TabItem );
  TabItem.pszText = "Statistics";
  TabCtrl_InsertItem( d_tabControl, 2, &TabItem );
  TabItem.pszText = "About";
  TabCtrl_InsertItem( d_tabControl, 3, &TabItem );

  if( d_serverThread.Startup( d_hInstance, NULL, d_hwnd ) ) {
    MessageBox( NULL, "Server thread initialization failure.", "Error!", MB_APPLMODAL );
    return 1;
  }
  d_connectDlg.SetCommServerThread( &d_serverThread );
  d_clientsDlg.SetCommServerThread( &d_serverThread );
  d_statsDlg.SetCommServerThread( &d_serverThread );

  d_connectDlg.Init( d_hInstance, IDD_TAB1 );
  d_clientsDlg.Init( d_hInstance, IDD_TAB2 );
  d_statsDlg.Init( d_hInstance, IDD_TAB3 );
  d_aboutDlg.Init( d_hInstance, IDD_TAB4 );

  TabChange();

  return cDialogBox::OnInitDialog( wparam, lparam );
}


LRESULT cNetworkServer::OnDestroy( WPARAM wparam, LPARAM lparam ) {
  return cDialogBox::OnDestroy( wparam, lparam );
}


LRESULT cNetworkServer::OnCommand( WPARAM wparam, LPARAM lparam ) {
/*
  switch( LOWORD( wparam ) ) {
    default: break;
  }
*/
  return cDialogBox::OnCommand( wparam, lparam );
}


LRESULT cNetworkServer::OnNotify( WPARAM wparam, LPARAM lparam ) {
  // You get this if the user wants to change the TAB Page
  if( ( (LPNMHDR)lparam )->code == TCN_SELCHANGE ) TabChange();

  return cDialogBox::OnNotify( wparam, lparam );
}


LRESULT cNetworkServer::OnClose( WPARAM wparam, LPARAM lparam ) {
  OnCancel();
  return 1;
}


LRESULT cNetworkServer::OnOther( unsigned int msg, WPARAM wparam, LPARAM lparam ) {
  switch( msg ) {
    case SM_GETHOST:
      d_serverThread.OnGetHost( wparam, lparam );
      d_pCurrTab->UpdateData();
      break;
    case SM_ASYNC:
      d_serverThread.OnAsync( wparam, lparam );
      d_pCurrTab->UpdateData();
      break;
    case SM_THREADBEGIN:  d_connectDlg.OnThreadBegin();  break;
    case SM_THREADEND:  d_connectDlg.OnThreadEnd();  break;
    case SM_THREADUPDATE:  d_pCurrTab->UpdateData();  break;
  }

  return cDialogBox::OnOther( msg, wparam, lparam );
}


void cNetworkServer::OnCancel() {
  if( d_serverThread.GetWorking() ) {
    MessageBox( NULL, "Network Server should not be quit until the server has been turned off.", "Warning!", MB_APPLMODAL );
    return;
  }
  if( IDYES == MessageBox( NULL, "Are you sure you want to quit?", "Network Server", MB_APPLMODAL | MB_YESNO ) ) {
    Destroy( 0 );
    // Bad C++ - Cleanup whatever work is being done
  }
}
////////////////////////////////////////////////////////////////////////////////

// Tab control methods
void cNetworkServer::TabChange() {
  int newPage;

  if( d_pCurrTab ) d_pCurrTab->Destroy( 0 );

  newPage = TabCtrl_GetCurSel( d_tabControl );

  switch( newPage ) {
    case 0:  d_pCurrTab = &d_connectDlg;  break;
    case 1:  d_pCurrTab = &d_clientsDlg;  break;
    case 2:  d_pCurrTab = &d_statsDlg;  break;
    case 3:  d_pCurrTab = &d_aboutDlg;  break;
  }

  d_pCurrTab->Create( d_hwnd );
  d_pCurrTab->Show( 1 );
}
////////////////////////////////////////////////////////////////////////////////

int cNetworkServer::Startup( HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpCmdLine, int nCmdShow ) {
  INITCOMMONCONTROLSEX icce;

  icce.dwSize = sizeof( INITCOMMONCONTROLSEX );
  icce.dwICC = ICC_INTERNET_CLASSES | ICC_LISTVIEW_CLASSES | ICC_PROGRESS_CLASS;
  if( !InitCommonControlsEx( &icce ) ) return 1;
  if( Init( hInst, IDD_MAIN ) ) return 1;
  if( Create() ) return 1;

  Show( 1 );

  return 0;
}


int cNetworkServer::Shutdown() {
  return 0;
}
////////////////////////////////////////////////////////////////////////////////

int cNetworkServer::MainLoop() {
  MSG msg;

  while( !d_quit ) {
    if( d_active ) {  //  When clients are in the game
      if( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) ) {  // Any windows messages?
        if( !GetMessage( &msg, NULL, 0, 0 ) ) break;
        TranslateMessage( &msg );
        DispatchMessage( &msg );
      } else if( Update() ) break;  // Update player positions
    } else {  // When minimized GetMessage returns 0
      if( !GetMessage( &msg, NULL, 0, 0 ) ) break;
      TranslateMessage( &msg );
      DispatchMessage( &msg );
    }
  }

  return msg.wParam;
}


int cNetworkServer::Update() {
  return d_serverThread.Update();
}

