#if !defined( __CCONNECTDLG_H )
#define __CCONNECTDLG_H
////////////////////////////////////////////////////////////////////////////////
#if !defined( __CCOMMSERVERTHREAD_H )
#include "cCommServerThread.h"
#endif
#if !defined( __CDIALOGBOX_H )
#include "cDialogBox.h"
#endif
#include <commctrl.h>
#include "resource.h"
////////////////////////////////////////////////////////////////////////////////

class cConnectDlg : public cDialogBox {
protected:
  cCommServerThread   *d_pServer;


  virtual LRESULT OnInitDialog( WPARAM wparam, LPARAM lparam ) {
    // This will be called every time you switch to the connect tab.
    CenterDlg();
    SetDlgItemText( d_hwnd, IDC_IP, d_pServer->GetServerName() );
    UpdateData();
    return cDialogBox::OnInitDialog( wparam, lparam );
  }


  virtual LRESULT OnDestroy( WPARAM wparam, LPARAM lparam ) {
    return 0;
  }


  void CenterDlg() {
    RECT WinRect, TabRect;

    GetWindowRect( GetDlgItem( GetParent( d_hwnd ), IDC_TAB1 ), &TabRect );
    GetWindowRect( GetParent( d_hwnd ), &WinRect );

    WinRect.left = TabRect.left - WinRect.left;
    WinRect.top = TabRect.top - WinRect.top - GetSystemMetrics( SM_CYCAPTION );

    TabCtrl_AdjustRect( GetDlgItem( GetParent( d_hwnd ), IDC_TAB1 ), FALSE, &WinRect );

    SetWindowPos( d_hwnd, HWND_TOP, WinRect.left, WinRect.top, 0, 0, SWP_NOSIZE );
  }


  virtual LRESULT OnCommand( WPARAM wparam, LPARAM lparam ) {
    switch( LOWORD( wparam ) ) {
      case IDC_CONNECT:  OnConnect();  break;
    }

    return cDialogBox::OnCommand( wparam, lparam );
  }


  void OnConnect() {
    if( !d_pServer ) {
      MessageBox( NULL, "Server thread class not found.", "Error!", MB_APPLMODAL );
      return;
    }

    switch( d_pServer->GetWorking() ) {
      case 0:
        char pass[ 32 ];
        int  port, maxClients;

        port = GetDlgItemInt( d_hwnd, IDC_PORT, NULL, 0 );
        maxClients = GetDlgItemInt( d_hwnd, IDC_MAXCLIENTS, NULL, 0 );

        if( port <= 0 || port >= 65536 ) {
          MessageBox( NULL, "Port must be between 0 and 65536.", "Caution", MB_APPLMODAL );
          return;
        }
        if( maxClients <= 0 || maxClients >= 256 ) {
          MessageBox( NULL, "Max clients must be between 0 and 256.", "Caution", MB_APPLMODAL );
          return;
        }
        // Start the thread.
        EnableWindow( GetDlgItem( d_hwnd, IDC_CONNECT ), 0 );
        GetDlgItemText( d_hwnd, IDC_PASS, pass, sizeof( pass ) );
        d_pServer->SetPass( pass );
        d_pServer->SetPort( port );
        d_pServer->SetMaxClients( maxClients );
        if( !d_pServer->StartThread() ) {
          MessageBox( NULL, "Thread startup failed.", "Error!", MB_APPLMODAL );
          SetDlgItemText( d_hwnd, IDC_CONNECT, "Start" );
          EnableWindow( GetDlgItem( d_hwnd, IDC_CONNECT ), 1 );
          break;
        }
        break;
      case 1:
      case 2:
        // Stop the thread.
        EnableWindow( GetDlgItem( d_hwnd, IDC_CONNECT ), 0 );
        if( IDYES == MessageBox( d_hwnd, "Are you sure you want to stop?", "Network Server", MB_APPLMODAL | MB_YESNO ) ) {
          // Cleanup whatever work is being done
          d_pServer->StopThread();
        } else EnableWindow( GetDlgItem( d_hwnd, IDC_CONNECT ), 1 );
        break;
      default: break;
    }
  }

public:
  cConnectDlg() : cDialogBox() {
    d_pServer = NULL;
    d_active = 0;
  }


  virtual ~cConnectDlg() {}


  void SetCommServerThread( cCommServerThread *pServer ) { d_pServer = pServer; }


  virtual void UpdateData() {
    if( !d_active ) return;

    SetDlgItemText( d_hwnd, IDC_IP, d_pServer->GetIP() );
    SetDlgItemText( d_hwnd, IDC_PASS, d_pServer->GetPass() );
    SetDlgItemInt( d_hwnd, IDC_PORT, d_pServer->GetPort(), 0 );
    SetDlgItemInt( d_hwnd, IDC_MAXCLIENTS, d_pServer->GetMaxClients(), 0 );

    switch( d_pServer->GetWorking() ) {
      case 0:
        EnableWindow( GetDlgItem( d_hwnd, IDC_PASS ), 1 );
        EnableWindow( GetDlgItem( d_hwnd, IDC_PORT ), 1 );
        EnableWindow( GetDlgItem( d_hwnd, IDC_MAXCLIENTS ), 1 );
        SetDlgItemText( d_hwnd, IDC_CONNECT, "Start" );
        break;
      default:
        EnableWindow( GetDlgItem( d_hwnd, IDC_PASS ), 0 );
        EnableWindow( GetDlgItem( d_hwnd, IDC_PORT ), 0 );
        EnableWindow( GetDlgItem( d_hwnd, IDC_MAXCLIENTS ), 0 );
        SetDlgItemText( d_hwnd, IDC_CONNECT, "Stop" );
        break;
    }
  }


  void OnThreadBegin() {
    if( !d_active ) return;

    SetDlgItemText( d_hwnd, IDC_CONNECT, "Stop" );
    EnableWindow( GetDlgItem( d_hwnd, IDC_CONNECT ), 1 );
    EnableWindow( GetDlgItem( d_hwnd, IDC_PASS ), 0 );
    EnableWindow( GetDlgItem( d_hwnd, IDC_PORT ), 0 );
    EnableWindow( GetDlgItem( d_hwnd, IDC_MAXCLIENTS ), 0 );
  }


  void OnThreadEnd() {
    if( !d_active ) return;

    SetDlgItemText( d_hwnd, IDC_CONNECT, "Start" );
    EnableWindow( GetDlgItem( d_hwnd, IDC_CONNECT ), 1 );
    EnableWindow( GetDlgItem( d_hwnd, IDC_PASS ), 1 );
    EnableWindow( GetDlgItem( d_hwnd, IDC_PORT ), 1 );
    EnableWindow( GetDlgItem( d_hwnd, IDC_MAXCLIENTS ), 1 );
  }
};


#endif

