#if !defined( __CCOMMSERVERTHREAD_H )
#define __CCOMMSERVERTHREAD_H
////////////////////////////////////////////////////////////////////////////////
#if !defined( __CCOMM_H )
#include "cComm.h"
#endif
#if !defined( __CMSG_H )
#include "cMsg.h"
#endif
#if !defined( __CPLAYER_H )
#include "cPlayer.h"
#endif
#if !defined( __CMISSILE_H )
#include "cMissile.h"
#endif
////////////////////////////////////////////////////////////////////////////////
#define SM_THREADBEGIN              ( WM_USER + 3 )
#define SM_THREADEND                ( WM_USER + 4 )
#define SM_THREADUPDATE             ( WM_USER + 5 )

#define NS_CLIENTVERSIONMAJOR       0
#define NS_CLIENTVERSIONMINOR       1

#define SNAPSHOTS_PER_SECOND        20
#define TIME_PER_SNAPSHOT           ( 1000 / SNAPSHOTS_PER_SECOND )
////////////////////////////////////////////////////////////////////////////////

class cCommServerThread : public cComm {
protected:
  int                     d_working;
//  HWND                    d_hwnd;  // declared in cComm

  char                    d_pass[ 32 ];  // password to connect
  DWORD                   d_startTime,
                          d_lastUpdate,
                          d_updateSendDelay,
                          d_packetId;  // To be more compatible with UDP system
  int                     d_maxClients,
                          d_numClients;  // currently connected
  tcLinkedList<cPlayer>   d_clients;
  tcLinkedList<cMissile>  d_missiles;
  tcLinkedList<cVehicle>  d_vehicles;

  virtual long            DetermineSize( int type );

  void                    ParseQueuedMessages();
  int                     ParseLoginRequest( tcLinkedList<cPlayer> *pClient, void *pBuffer );
  int                     ParseMoveNotice( tcLinkedList<cPlayer> *pClient, void *pBuffer );
  int                     ParseKeepAlive( tcLinkedList<cPlayer> *pClient, void *pBuffer );

  int                     CreateSnapshot();

  int                     CollideClientClient(  tcLinkedList<cPlayer> *pClient,  tcLinkedList<cPlayer> *pOther );
  int                     CollideClientMissile(  tcLinkedList<cPlayer> *pClient,  tcLinkedList<cMissile> *pMissile );

public:
  cCommServerThread();
  virtual ~cCommServerThread();

  // Intializing
  int                     Startup( HINSTANCE hInst, HINSTANCE hPrev, HWND hwnd );
  int                     Shutdown();

  // Thread control
  int                     StartThread();
  int                     PauseThread();
  int                     StopThread();

  int                     Update();

  // Overidden methods
  virtual int             OnGetHost( WPARAM wparam, LPARAM lparam );
  virtual LRESULT         OnAsync( WPARAM wparam, LPARAM lparam );

  // Member variable access methods
  int                     GetWorking() { return d_working; }
  void                    SetMaxClients( int maxClients ) { d_maxClients = maxClients; }
  int                     GetMaxClients() { return d_maxClients; }
  int                     GetNumClients() { return d_numClients; }
  DWORD                   GetStartTime() { return d_startTime; }


  void                    SetPass( char *pPass ) {
    if( pPass ) strcpy( d_pass, pPass );
  }


  char                    *GetPass() { return d_pass; }
  tcLinkedList<cPlayer>   *GetClients() { return &d_clients; }
  tcLinkedList<cMissile>  *GetMissiles() { return &d_missiles; }
};


#endif

