/* NETWORK SERVER: CommServerThread.cpp
 * Created 24/06/99 Dan Royer
 * BAD C++ - There is a change that thread critical section data could cause problems...
 */
#if !defined( __CCOMMSERVERTHREAD_H )
#include "cCommServerThread.h"
#endif
#include <stdio.h>  // sprintf
////////////////////////////////////////////////////////////////////////////////

cCommServerThread::cCommServerThread() : cComm() {
  d_working = 0;
  d_maxClients = 8;
  d_numClients = 0;
  d_startTime = 0;
  d_lastUpdate = 0;
  d_packetId = 0;
  memset( d_pass, 0, sizeof( d_pass ) );
}


cCommServerThread::~cCommServerThread() {
//  if( (int)d_threadId != -1 ) CloseHandle( d_threadId );
}
////////////////////////////////////////////////////////////////////////////////

int cCommServerThread::Startup( HINSTANCE hInst, HINSTANCE hPrev, HWND hwnd ) {
  d_hwnd = hwnd;

  return cComm::Startup( MODE_SERVER, hwnd );
}


int cCommServerThread::Shutdown() {
  return 0;
}
////////////////////////////////////////////////////////////////////////////////

int cCommServerThread::StartThread() {
  d_startTime = GetTickCount();
  SendMessage( d_hwnd, SM_THREADBEGIN, 0, 0 );

  // Check we have a valid number of maxclients...
  if( d_maxClients <= 0 ) {
    d_working = 0;  // because this is not caused by StopThread()
    PostMessage( d_hwnd, SM_THREADEND, 0, 0 );
    return 0;
  }
  d_vehicles.LoadModel( NULL );

  GetHost();

  return 1;
}


int cCommServerThread::PauseThread() {
  if( d_working == 1 ) d_working = 2;
  else if( d_working == 2 ) d_working = 1;

  return 0;
}


int cCommServerThread::StopThread() {
  tcLinkedList<cPlayer> *pClient;

  if( !d_working ) return 0;

  d_working = 0;

  d_working = 0;
  Disconnect();
  PostMessage( d_hwnd, SM_THREADEND, 0, 0 );
  while( ( pClient = d_clients.GetNext() ) ) delete pClient;
  d_vehicles.UnloadModel();

  return 0;
}
////////////////////////////////////////////////////////////////////////////////

int cCommServerThread::Update() {
  if( !d_working ) return 0;

  tcLinkedList<cMissile>          *pMissile, *pNextMissile;
  tcLinkedListItterator<cPlayer>  itterClient, itterOther;
  DWORD                           time, deltaTime;
  tcLinkedListItterator<cMissile> itterMissile;  // I could use pMissile, but I chose not to!  HA!
  cVector3                        collide;

  time = GetTickCount();
  deltaTime = time - d_lastUpdate;

  // Read in data.
  ParseQueuedMessages();

  // Close sockets that are idle too long.
  for( itterClient = d_clients.GetNext(); itterClient(); ++itterClient ) {
    if( !itterClient()->GetSecurity() ) continue;  // not logged in yet

    if( itterClient()->GetIdleTime() >= IDLE_TIMEOUT ) {  // Disconnect the idle client
      shutdown( itterClient()->GetSocket(), SD_SEND );
    }

    itterClient()->Update( deltaTime );
  }

  for( pMissile = d_missiles.GetNext(); pMissile; pMissile = pNextMissile ) {
    pNextMissile = pMissile->GetNext();
    if( pMissile->GetState() == STATE_DEAD ) delete pMissile;
    else pMissile->Update( deltaTime );
  }

  // Collision detection
  for( itterClient = d_clients.GetNext(); itterClient(); ++itterClient ) {
    if( !itterClient()->GetState() != STATE_DEAD ) continue;  // Can only be alive if logged in.

    // Player/player
    for( itterOther = d_clients.GetNext(); itterOther(); ++itterOther ) {
      if( itterOther() == itterClient() ) continue;  // there's no escaping yourself...
      if( !itterOther()->GetState() != STATE_DEAD ) continue;  // Can only be alive if logged in.
      collide.Position( itterOther()->GetLocation()->a30 - itterClient()->GetLocation()->a30,
                        itterOther()->GetLocation()->a31 - itterClient()->GetLocation()->a31,
                        itterOther()->GetLocation()->a32 - itterClient()->GetLocation()->a32 );
      if( collide.Length() < 20 ) {
        CollideClientClient( itterClient(), itterOther() );
        break;
      }
    }
    if( itterOther() ) break;  // Collided - stop checking

    // Player/missile
    for( itterMissile = d_missiles.GetNext(); itterMissile(); ++itterMissile ) {
      collide.Position( itterMissile()->GetLocation()->a30 - itterClient()->GetLocation()->a30,
                        itterMissile()->GetLocation()->a31 - itterClient()->GetLocation()->a31,
                        itterMissile()->GetLocation()->a32 - itterClient()->GetLocation()->a32 );
      if( collide.Length() < 15 ) {
        CollideClientMissile( itterClient(), itterMissile() );
        break;
      }
    }
    if( itterMissile() ) break;  // Collided - stop checking
  }

  // Take snapshot if delay elapsed.
  if( d_updateSendDelay > TIME_PER_SNAPSHOT ) {
    if( d_numClients ) {
      if( CreateSnapshot() ) return 1;
    }
    d_updateSendDelay -= TIME_PER_SNAPSHOT;
  }

  d_updateSendDelay += deltaTime;
  d_lastUpdate = GetTickCount();

  return 0;
}


// Create a new cMsgSnapshot
int cCommServerThread::CreateSnapshot() {
  char                            *pBuffer, *pBuffer2;
  tcLinkedListItterator<cPlayer>  itterClient;
  tcLinkedList<cMsgQueue>         *pNewQueue;
  int                             size, i;
  cMsgMoveNotice                  *pMove;
  cMsgSnapshot                    *pSnap;

  // This could be allocated once at the start at size msgSnapshot + d_maxClients * size move notice.
  size = sizeof( cMsgSnapshot ) + d_numClients * sizeof( cMsgMoveNotice );
  pBuffer = new char[ size ];
  if( !pBuffer ) {
    MessageBox( NULL, "Memory allocation failure!", "Error!", MB_APPLMODAL );
    delete [] pBuffer;
    return 1;
  }

  // Build the snapshot
  pSnap = (cMsgSnapshot *)pBuffer;
  pSnap->d_type = MSG_SNAPSHOT;
  pSnap->d_numClients = d_numClients;
  pSnap->d_packetId = d_packetId;

  i = 0;
  pMove = (cMsgMoveNotice *)( pBuffer + sizeof( cMsgSnapshot ) );
  for( itterClient = d_clients.GetNext(); itterClient(); ++itterClient ) {
    if( !itterClient()->GetSecurity() ) continue;

    pMove->d_type = MSG_MOVENOTICE;
    pMove->d_obj.d_id = itterClient()->GetId();
    pMove->d_pos.Position( itterClient()->GetLocation()->a30,
                           itterClient()->GetLocation()->a31,
                           itterClient()->GetLocation()->a32 );
    pMove->d_motionFlags = itterClient()->GetMotionFlags();
    pMove->d_angle = itterClient()->GetAngle();
    i++;
    pMove = (cMsgMoveNotice *)( pBuffer + sizeof( cMsgSnapshot ) + i * sizeof( cMsgMoveNotice ) );
  }

  // Send the snapshot, provided they are logged in.
  for( itterClient = d_clients.GetNext(); itterClient(); ++itterClient ) {
    if( !itterClient()->GetSecurity() ) continue;

    pBuffer2 = new char[ size ];
    pNewQueue = new tcLinkedList<cMsgQueue>;
    if( !pNewQueue || !pBuffer2 ) {
      MessageBox( NULL, "Memory allocation failure!", "Error!", MB_APPLMODAL );
      // One may have been created...
      if( pNewQueue ) delete pNewQueue;
      if( pBuffer2 ) delete [] pBuffer2;
      delete [] pBuffer;
      return 1;
    }
    memcpy( pBuffer2, pBuffer, size );
    pSnap = (cMsgSnapshot *)pBuffer2;
    pSnap->d_lastPacketReceived = itterClient()->GetPacketId();
    pNewQueue->SetBuffer( pBuffer2, size, 1 );
    itterClient()->AddOutMsgQueue( pNewQueue );
    WriteFromClientQueue( itterClient() );
  }

  // Now delete the original buffer.
  delete [] pBuffer;

  d_packetId++;

  return 0;
}


int cCommServerThread::CollideClientClient( tcLinkedList<cPlayer> *pClient, tcLinkedList<cPlayer> *pOther ) {
  tcLinkedListItterator<cPlayer>  itterClient;
  tcLinkedList<cMsgQueue>         *pNewQueue;
  cMsgCollideNotice               *pCollide;

  pClient->SetState( STATE_DYING );
  pOther->SetState( STATE_DYING );

  for( itterClient = d_clients.GetNext(); itterClient(); ++itterClient ) {
    pNewQueue = new tcLinkedList<cMsgQueue>;
    pCollide = new cMsgCollideNotice;
    if( !pNewQueue || !pCollide ) {
      MessageBox( NULL, "Memory allocation failure!", "Error!", MB_APPLMODAL );
      // One may have been created...
      if( pNewQueue ) delete pNewQueue;
      if( pCollide ) delete pCollide;
      return 1;
    }
    pCollide->d_type = MSG_COLLIDENOTICE;
    pCollide->d_colliders[ 0 ].d_type = OBJTYPE_PLAYER;
    pCollide->d_colliders[ 0 ].d_id = pClient->GetId();
    pCollide->d_colliders[ 1 ].d_type = OBJTYPE_PLAYER;
    pCollide->d_colliders[ 1 ].d_id = pOther->GetId();
    pNewQueue->SetBuffer( (void *)pCollide, sizeof( cMsgCollideNotice ) );
    itterClient()->AddOutMsgQueue( pNewQueue );
    WriteFromClientQueue( itterClient() );
  }

  return 0;
}


int cCommServerThread::CollideClientMissile( tcLinkedList<cPlayer> *pClient, tcLinkedList<cMissile> *pMissile ) {
  tcLinkedListItterator<cPlayer>  itterClient;
  tcLinkedList<cMsgQueue>         *pNewQueue;
  cMsgCollideNotice               *pCollide;

  pClient->SetState( STATE_DYING );
  pMissile->SetState( STATE_DYING );

  for( itterClient = d_clients.GetNext(); itterClient(); ++itterClient ) {
    pNewQueue = new tcLinkedList<cMsgQueue>;
    pCollide = new cMsgCollideNotice;
    if( !pNewQueue || !pCollide ) {
      MessageBox( NULL, "Memory allocation failure!", "Error!", MB_APPLMODAL );
      // One may have been created...
      if( pNewQueue ) delete pNewQueue;
      if( pCollide ) delete pCollide;
      return 1;
    }
    pCollide->d_type = MSG_COLLIDENOTICE;
    pCollide->d_colliders[ 0 ].d_type = OBJTYPE_PLAYER;
    pCollide->d_colliders[ 0 ].d_id = pClient->GetId();
    pCollide->d_colliders[ 1 ].d_type = OBJTYPE_MISSILE;
    pCollide->d_colliders[ 1 ].d_id = pMissile->GetId();
    pNewQueue->SetBuffer( (void *)pCollide, sizeof( cMsgCollideNotice ) );
    itterClient()->AddOutMsgQueue( pNewQueue );
    WriteFromClientQueue( itterClient() );
  }

  return 0;
}


void cCommServerThread::ParseQueuedMessages() {
  tcLinkedList<cMsgQueue>         *pQueue, *pNextQueue;
  tcLinkedListItterator<cPlayer>  itterClient;
  tcLinkedList<cPlayer>           *pClient;

  for( itterClient = d_clients.GetNext(); itterClient(); ++itterClient ) {
    pClient = itterClient();

    for( pQueue = pClient->GetNextMsgIn(); pQueue; pQueue = pNextQueue ) {
      pNextQueue = pQueue->GetNext();
      if( !pQueue->GetSize() || pQueue->GetSize() != pQueue->GetTransmitted() ) break;

      // Find out what the server sent us.
      switch( ( (cMsg *)pQueue->GetBuffer() )->d_type ) {
        case MSG_LOGINREQUEST:  ParseLoginRequest( pClient, pQueue->GetBuffer() );  break;
        case MSG_MOVENOTICE:
          if( ParseMoveNotice( pClient, pQueue->GetBuffer() ) == -1 ) continue;  // not processed yet!
          break;
        case MSG_KEEPALIVE:
          if( ParseKeepAlive( pClient, pQueue->GetBuffer() ) == -1 ) continue;  // not processed yet!
          break;
        case MSG_SPAWNNOTICE:  // not sent by client
        case MSG_DEATHNOTICE:  // not sent by client
        case MSG_COLLIDENOTICE:  // not sent by client
        default:
          // An unrecognized message was sent, meaning something has gone
          // very wrong with (at least) this client.  Disconnect that client.
          char errorBuffer[ 128 ];

          sprintf( errorBuffer, "type (?) = %d\nclient id = %d\nsize = %d",
            ( (cMsg *)pQueue->GetBuffer() )->d_type, pClient->GetId(), pQueue->GetSize() );
          MessageBox( NULL, errorBuffer, "INVALID MESSAGE", MB_APPLMODAL );

          shutdown( pClient->GetSocket(), SD_SEND );
          break;
      }
      // We're done with it, get rid of it.
      delete pQueue;
    }
  }
}


int cCommServerThread::ParseLoginRequest( tcLinkedList<cPlayer> *pClient, void *pBuffer ) {
  tcLinkedListItterator<cMissile> itterMissile;
  tcLinkedListItterator<cPlayer>  itterOther;
  tcLinkedList<cMsgQueue>         *pNewQueue;
  cMsgLoginRequest                *pRequest;
  cMsgConnectNotice               *pConnect;  // for clients
  cMsgSpawnNotice                 *pSpawn;  // for missiles
  cMsgLoginReply                  *pReply;
  eLoginReply                     success;

  pRequest = (cMsgLoginRequest *)pBuffer;

  pReply = new cMsgLoginReply;
  pNewQueue = new tcLinkedList<cMsgQueue>;
  if( !pNewQueue || !pReply ) {
    MessageBox( NULL, "Memory allocation failure!", "Error!", MB_APPLMODAL );
    // One may have been created...
    if( pNewQueue ) delete pNewQueue;
    if( pReply ) delete pReply;
    return 1;
  }

  success = LOGIN_OK;

  if( d_numClients > d_maxClients ) {
    success = LOGIN_BADFULL;
    // Client version does not match version supported by this server.
  } else if( pRequest->d_version[ 0 ] != NS_CLIENTVERSIONMAJOR || pRequest->d_version[ 1 ] != NS_CLIENTVERSIONMINOR ) {
    success = LOGIN_BADOUTDATED;
  } else if( strlen( d_pass ) && strncmp( pRequest->d_pass, d_pass, 32 ) ) {
    // Client password does not match server password.
    success = LOGIN_BADPASS;
  } else if( !strlen( pRequest->d_name ) ) {
    // Client name field blank.
    success = LOGIN_BADNAME;
  } else {
    // Client name already being used.
    for( itterOther = d_clients.GetNext(); itterOther(); ++itterOther ) {
      if( !itterOther()->GetSecurity() ) continue;
      if( !strncmp( itterOther()->GetName(), pRequest->d_name, 32 ) ) break;
    }
    if( itterOther() ) success = LOGIN_BADNAME;
  }

  // Fill out the data...
  pReply->d_type = MSG_LOGINREPLY;
  pReply->d_success = success;
  pReply->d_maxClients = d_maxClients;
  pReply->d_lastPacketId = d_packetId;
  pReply->d_id = pClient->GetId();
  pNewQueue->SetBuffer( (void *)pReply, sizeof( cMsgLoginReply ) );
  pClient->AddOutMsgQueue( pNewQueue );
  WriteFromClientQueue( pClient );

  // Stop now if login was bad
  // Bad C++ - Server should force disconnect rather than wait for client to do it...
  if( success != LOGIN_OK ) return 0;

  pClient->SetPacketId( d_packetId );
  pClient->SetName( pRequest->d_name );
  pClient->SetVehicle( &d_vehicles );
  pClient->SetSecurity( 1 );

  // Send a connectNotice about the new client to every old client and
  // send a connectNotice about every old client to the new client.
  for( itterOther = d_clients.GetNext(); itterOther(); ++itterOther ) {
    if( !itterOther()->GetSecurity() ) continue;  // not logged in
    if( itterOther() == pClient ) continue;

    pConnect = new cMsgConnectNotice;
    pNewQueue = new tcLinkedList<cMsgQueue>;
    if( !pNewQueue || !pConnect ) {
      MessageBox( NULL, "Memory allocation failure!", "Error!", MB_APPLMODAL );
      // One may have been created...
      if( pNewQueue ) delete pNewQueue;
      if( pConnect ) delete pConnect;
      return 1;
    }

    pConnect->d_type = MSG_CONNECTNOTICE;
    strncpy( pConnect->d_name, itterOther()->GetName(), 32 );
    pConnect->d_obj.d_type = OBJTYPE_PLAYER;
    pConnect->d_obj.d_id = itterOther()->GetId();
    pConnect->d_angle = itterOther()->GetAngle();
    pConnect->d_pos.d_x = itterOther()->GetLocation()->a30;
    pConnect->d_pos.d_y = itterOther()->GetLocation()->a31;
    pConnect->d_pos.d_z = itterOther()->GetLocation()->a32;
    pConnect->d_motionFlags = itterOther()->GetMotionFlags();
    pConnect->d_state = itterOther()->GetState();
    pConnect->d_connState = STATE_CONNECTED;
    pNewQueue->SetBuffer( pConnect, sizeof( cMsgConnectNotice ) );
    pClient->AddOutMsgQueue( pNewQueue );
    WriteFromClientQueue( pClient );

    pConnect = new cMsgConnectNotice;
    pNewQueue = new tcLinkedList<cMsgQueue>;
    if( !pNewQueue || !pConnect ) {
      MessageBox( NULL, "Memory allocation failure!", "Error!", MB_APPLMODAL );
      // One may have been created...
      if( pNewQueue ) delete pNewQueue;
      if( pConnect ) delete pConnect;
      return 1;
    }
    pConnect->d_type = MSG_CONNECTNOTICE;
    strncpy( pConnect->d_name, pClient->GetName(), 32 );
    pConnect->d_obj.d_id = pClient->GetId();
    // angle, pos and vel don't matter until player spawns
    pConnect->d_state = STATE_DEAD;
    pConnect->d_connState = STATE_CONNECTING;
    pNewQueue->SetBuffer( (void *)pConnect, sizeof( cMsgConnectNotice ) );
    itterOther()->AddOutMsgQueue( pNewQueue );
    WriteFromClientQueue( itterOther() );
  }

  // Now inform the new client about all the missiles flying around.
  // We keep the client informed of every missile everywhere because it only has to
  // be sent once, which means less work for the server & less network chatter.
  for( itterMissile = d_missiles.GetNext(); itterMissile(); ++itterMissile ) {
    pSpawn = new cMsgSpawnNotice;
    pNewQueue = new tcLinkedList<cMsgQueue>;
    if( !pNewQueue || !pSpawn ) {
      MessageBox( NULL, "Memory allocation failure!", "Error!", MB_APPLMODAL );
      // One may have been created...
      if( pNewQueue ) delete pNewQueue;
      if( pSpawn ) delete pSpawn;
      return 1;
    }

    pSpawn->d_type = MSG_SPAWNNOTICE;
    pSpawn->d_obj.d_type = OBJTYPE_MISSILE;
    pSpawn->d_obj.d_id = itterMissile()->GetId();
    pSpawn->d_creator.d_type = OBJTYPE_PLAYER;  // Sorry, no automated planetary defence grids...
    pSpawn->d_creator.d_id = itterMissile()->GetCreator();
    pSpawn->d_pos.Position( itterMissile()->GetLocation()->a30,
                            itterMissile()->GetLocation()->a31,
                            itterMissile()->GetLocation()->a32 );
    pSpawn->d_angle = pClient->GetAngle();
    pNewQueue->SetBuffer( (void *)pSpawn, sizeof( cMsgSpawnNotice ) );
    pClient->AddOutMsgQueue( pNewQueue );
    WriteFromClientQueue( pClient );
  }

  return 0;
}


int cCommServerThread::ParseMoveNotice( tcLinkedList<cPlayer> *pClient, void *pBuffer ) {
  int                             numMissiles, newMissileId;
  cVector3                        pos, vel, xAxis;
  tcLinkedListItterator<cMissile> itterMissile;
  cMsgSpawnNotice                 *pSpawnSend;
  tcLinkedListItterator<cPlayer>  itterOther;
  tcLinkedList<cMsgQueue>         *pNewQueue;
  tcLinkedList<cMissile>          *pNewMiss;
  cMsgMoveNotice                  *pMove;
  cMatrix4                        *pMat;

  pMove = (cMsgMoveNotice *)pBuffer;

  if( pMove->d_packetId > d_packetId ) return -1;  // too young, wait.
  if( pMove->d_packetId < d_packetId - 1 ) return 0;  // too old, ignore.

  if( pClient->GetPacketId() < pMove->d_packetId ) pClient->SetPacketId( pMove->d_packetId );

  if( pClient->GetState() != STATE_DEAD ) {
    pClient->SetIdleTime( 0 );
    pClient->SetMotionFlags( pMove->d_motionFlags );
    pClient->SetAngle( pMove->d_angle );
    pClient->SetIdleTime( 0 );

    if( !( pMove->d_motionFlags & MOTION_FIRESTART ) ) return 0;

    // Player wants to shoot/is shooting.  Notify all clients.
    // Player has hit fire button.  no shot actually goes out until server says it's ok.
    // Player always has ammo but we want to limit the number of active missiles/player

    // Scan through the list of missiles and count how many belong to this player
    numMissiles = 0;
    for( itterMissile = d_missiles.GetNext(); itterMissile(); ++itterMissile ) {
      if( itterMissile()->GetCreator() == pClient->GetId() ) numMissiles++;
    }
    if( numMissiles >= 25 ) return 0;

    // Of course, if we stored the number of missiles in the player object
    // then we'd be able to do some tests client side and save us the work...
    for( newMissileId = 1; newMissileId != 0; newMissileId++ ) {
      for( itterMissile = d_missiles.GetNext(); itterMissile(); ++itterMissile ) {
        if( itterMissile()->GetId() == newMissileId ) break;
      }
      if( !itterMissile() ) break;
    }
    if( !newMissileId ) {
      MessageBox( NULL, "Too many missiles in game (cannot find unique id)!", "Error!", MB_APPLMODAL );
      return 2;
    }
    // Spawn the missile at the player's position + x_axis * 5

    pNewMiss = new tcLinkedList<cMissile>;
    if( !pNewMiss ) {
      MessageBox( NULL, "Not enough ram to create new missile!", "Error!", MB_APPLMODAL );
      return 3;
    }
    // Give it the same angle as the player's ship
    // Animate the rocket to accelerate for the first n seconds?
    pMat = pClient->GetLocation();
    xAxis.Position( pMat->a00, pMat->a01, pMat->a02 );
    pos.Position( pMat->a30, pMat->a31, pMat->a32 );
    pos += xAxis * 22.5f;  // Ship nose + half missile, only looks right on default model.
    pNewMiss->Fire( pos, 50.0f, pClient->GetAngle() );  // pClient->GetAngle() instead of 0
    // Mark this rocket as having come from pClient.
    pNewMiss->SetCreator( pClient->GetId() );
    pNewMiss->SetId( newMissileId );

    for( itterOther = d_clients.GetNext(); itterOther(); ++itterOther ) {
      if( !itterOther()->GetSecurity() ) continue;  // not logged in

      pSpawnSend = new cMsgSpawnNotice;
      pNewQueue = new tcLinkedList<cMsgQueue>;
      if( !pNewQueue || !pSpawnSend ) {
        MessageBox( NULL, "Memory allocation failure!", "Error!", MB_APPLMODAL );
        // One may have been created...
        if( pNewQueue ) delete pNewQueue;
        if( pSpawnSend ) delete pSpawnSend;
        return 1;
      }
      pSpawnSend->d_type = MSG_SPAWNNOTICE;
      pSpawnSend->d_obj.d_type = OBJTYPE_MISSILE;
      pSpawnSend->d_obj.d_id = newMissileId;
      pSpawnSend->d_creator.d_type = OBJTYPE_PLAYER;
      pSpawnSend->d_creator.d_id = pClient->GetId();
      pSpawnSend->d_pos = pos;
      pSpawnSend->d_angle = pClient->GetAngle();

      pNewQueue->SetBuffer( (void *)pSpawnSend, sizeof( cMsgSpawnNotice ) );
      itterOther()->AddOutMsgQueue( pNewQueue );
      WriteFromClientQueue( itterOther() );
    }
  } else {  // player is dead
    if( !pClient->GetSecurity() ) return 1;  // not logged in
    if( !( pMove->d_motionFlags & MOTION_FIRESTART ) ) return 0;

    // Player wants to spawn.  Notify all clients.
    pClient->SetState( STATE_BIRTH );
    pClient->GetLocation()->MakeIdentity();
    pos.Position( 0.0f, 0.0f, 0.0f );
    vel.Position( 0.0f, 0.0f, 0.0f );
    pClient->GetLocation()->a30 = pos.d_x;
    pClient->GetLocation()->a31 = pos.d_y;
    pClient->GetLocation()->a32 = pos.d_z;
    pClient->SetVelocity( vel );
    pClient->SetAngle( 0 );

    for( itterOther = d_clients.GetNext(); itterOther(); ++itterOther ) {
      if( !itterOther()->GetSecurity() ) continue;  // not logged in
      pSpawnSend = new cMsgSpawnNotice;
      pNewQueue = new tcLinkedList<cMsgQueue>;
      if( !pNewQueue || !pSpawnSend ) {
        MessageBox( NULL, "Memory allocation failure!", "Error!", MB_APPLMODAL );
        // One may have been created...
        if( pNewQueue ) delete pNewQueue;
        if( pSpawnSend ) delete pSpawnSend;
        return 1;
      }
      pSpawnSend->d_type = MSG_SPAWNNOTICE;
      pSpawnSend->d_obj.d_type = OBJTYPE_PLAYER;
      pSpawnSend->d_obj.d_id = pClient->GetId();
      pSpawnSend->d_creator.d_type = OBJTYPE_UNDEFINED;
      pSpawnSend->d_creator.d_id = 0;
      pSpawnSend->d_pos = pos;
      pSpawnSend->d_angle = 0;

      pNewQueue->SetBuffer( (void *)pSpawnSend, sizeof( cMsgSpawnNotice ) );
      itterOther()->AddOutMsgQueue( pNewQueue );
      WriteFromClientQueue( itterOther() );
    }
  }

  return 0;
}


int cCommServerThread::ParseKeepAlive( tcLinkedList<cPlayer> *pClient, void *pBuffer ) {
  tcLinkedListItterator<cPlayer>  itterClient;
  cMsgKeepAlive                   *pAlive;

  pAlive = (cMsgKeepAlive *)pBuffer;

  if( pAlive->d_packetId > d_packetId ) return -1;  // too young, wait.
  if( pAlive->d_packetId < d_packetId - 1 ) return 0;  // too old, ignore.

  if( pClient->GetPacketId() < pAlive->d_packetId ) pClient->SetPacketId( pAlive->d_packetId );

  if( pAlive->d_obj.d_type != OBJTYPE_PLAYER ) return 1;

  for( itterClient = d_clients.GetNext(); itterClient(); ++itterClient ) {
    if( itterClient()->GetId() == pAlive->d_obj.d_id ) break;
  }
  if( !itterClient() ) return 1;

  itterClient()->SetIdleTime( 0 );  // We're staying alive, thank you.

  return 0;
}
////////////////////////////////////////////////////////////////////////////////

int cCommServerThread::OnGetHost( WPARAM wparam, LPARAM lparam ) {
  int returnCode;

  returnCode = cComm::OnGetHost( wparam, lparam );
  if( returnCode ) {
    char buffer[ 100 ];

    sprintf( buffer, "OnGetHost() error %d.", returnCode );
    MessageBox( NULL, buffer, "Error!", MB_APPLMODAL );
    d_working = 0;
  }

  // May have been cancelled while waiting
  d_working = 1;
  d_startTime = GetTickCount();
  d_lastUpdate = GetTickCount();
  d_packetId = 0;
  d_updateSendDelay = 0;
  SendMessage( d_hwnd, SM_THREADBEGIN, 0, 0 );

  return returnCode;
}


LRESULT cCommServerThread::OnAsync( WPARAM wparam, LPARAM lparam ) {
  tcLinkedListItterator<cPlayer>  itterClient, itterOther;
  int                             event, errmsg;
  tcLinkedList<cMsgQueue>         *pNewQueue;

  event = WSAGETSELECTEVENT( lparam );
  errmsg = WSAGETSELECTERROR( lparam );
  switch( event ) {
    case FD_CONNECT:
      // Every time WSAAsyncSelect is called it sends messages to SM_ASYNC where it sends
      // the error code from WSAAsyncSelect, if any.  This means we may get repeated calls
      // to FD_CONNECT and FD_WRITE we don't want, under certain circumstances.

      // In server mode we don't really care about FD_CONNECT.
      cComm::Connected( 0 );
      break;
    case FD_ACCEPT:  // New client connection
      tcLinkedList<cPlayer> *pNewPlayer;
      SOCKET                newSocket;
      SOCKADDR_IN           address;
      int                   size;

      size = sizeof( SOCKADDR );
      newSocket = accept( d_socket, (LPSOCKADDR)&address, &size );
      if( newSocket == INVALID_SOCKET ) {
        // crap!
        MessageBox( NULL, "Socket acceptance failure!", "Error!", MB_APPLMODAL );
        return 1;
      }
      pNewPlayer = new tcLinkedList<cPlayer>;
      if( !pNewPlayer ) {
        // crap!
        MessageBox( NULL, "Memory allocation failure!", "Error!", MB_APPLMODAL );
        return 1;
      }
      // Make sure each client has a unique ID
      d_numClients++;
      pNewPlayer->SetId( newSocket );  // their socket number is their id.
      pNewPlayer->SetSocket( newSocket );
      d_clients.Link( pNewPlayer );
      break;
    case FD_OOB:  // Out of band data has arrived
      break;
    case FD_READ:  // Incomming data to be read
      for( itterClient = d_clients.GetNext(); itterClient(); ++itterClient ) {
        if( itterClient()->GetSocket() == (SOCKET)wparam ) break;
      }
      if( itterClient() ) ReadIntoClientQueue( itterClient() );
      break;
    case FD_WRITE: // Permission granted to send data
      for( itterClient = d_clients.GetNext(); itterClient(); ++itterClient ) {
        if( itterClient()->GetSocket() == (SOCKET)wparam ) break;
      }
      if( itterClient() ) WriteFromClientQueue( itterClient() );
      break;
    case FD_CLOSE:  // Disconnecting
      // At this point we probably can't write to the socket because
      // of shutdown( socket, SW_READ )...
      for( itterClient = d_clients.GetNext(); itterClient(); ++itterClient ) {
        if( itterClient()->GetSocket() == (SOCKET)wparam ) break;
      }

      cMsgConnectNotice *pNotice;

      for( itterOther = d_clients.GetNext(); itterOther(); ++itterOther ) {
        if( itterOther() == itterClient() ) continue;

        pNotice = new cMsgConnectNotice;
        pNewQueue = new tcLinkedList<cMsgQueue>;
        if( !pNewQueue || !pNotice ) {
          MessageBox( NULL, "Memory allocation failure!", "Error!", MB_APPLMODAL );
          // One may have been created...
          if( pNewQueue ) delete pNewQueue;
          if( pNotice ) delete pNotice;
          break;
        }
        pNotice->d_type = MSG_CONNECTNOTICE;
        pNotice->d_obj.d_id = itterClient()->GetId();
        pNotice->d_connState = STATE_DISCONNECTING;
        pNewQueue->SetBuffer( pNotice, sizeof( cMsgConnectNotice ) );
        itterOther()->AddOutMsgQueue( pNewQueue );
        WriteFromClientQueue( itterOther() );
      }
      // Read in any pending data on the socket
      closesocket( (SOCKET)wparam );
      delete itterClient();
      d_numClients--;
      break;
  }

  return cComm::OnAsync( wparam, lparam );
}


long cCommServerThread::DetermineSize( int type ) {
  switch( (eMsgType)type ) {
    case MSG_DEFAULT:  return sizeof( cMsg );
    case MSG_LOGINREQUEST:  return sizeof( cMsgLoginRequest );
    case MSG_LOGINREPLY:  return sizeof( cMsgLoginReply );
    case MSG_CONNECTNOTICE:  return sizeof( cMsgConnectNotice );
    case MSG_SNAPSHOT:  return sizeof( cMsgSnapshot ) + d_numClients * sizeof( cMsgMoveNotice );
    case MSG_MOVENOTICE:  return sizeof( cMsgMoveNotice );
    case MSG_SPAWNNOTICE:  return sizeof( cMsgSpawnNotice );
    case MSG_DEATHNOTICE:  return sizeof( cMsgDeathNotice );
    case MSG_COLLIDENOTICE:  return sizeof( cMsgCollideNotice );
    case MSG_KEEPALIVE:  return sizeof( cMsgKeepAlive );
    default:  return sizeof( cMsg );
  }
}

