#if !defined( __CCLIENTSDLG_H )
#define __CCLIENTSDLG_H
////////////////////////////////////////////////////////////////////////////////
#if !defined( __CCOMMSERVERTHREAD_H )
#include "cCommServerThread.h"
#endif
#if !defined( __CDIALOGBOX_H )
#include "cDialogBox.h"
#endif
#include <commctrl.h>
#include "resource.h"
////////////////////////////////////////////////////////////////////////////////

class cClientsDlg : public cDialogBox {
protected:
  char                d_pass[ 32 ];
  int                 d_maxClients,
                      d_port;
  cCommServerThread   *d_pServer;

  virtual LRESULT OnInitDialog( WPARAM wparam, LPARAM lparam ) {
    LVCOLUMN col;
    HWND     listView;

    CenterDlg();

    listView = GetDlgItem( d_hwnd, IDC_CLIENTLIST );
    col.mask = LVCF_TEXT | LVCF_WIDTH | LVCF_FMT;
    col.fmt = LVCFMT_LEFT;
    col.cx = 100;
    col.pszText = "Client";
    ListView_InsertColumn( listView, 0, &col );
    col.cx = 90;
    col.pszText = "IP";
    ListView_InsertColumn( listView, 1, &col );
    col.cx = 51;
    col.pszText = "State";
    ListView_InsertColumn( listView, 2, &col );
    col.cx = 70;
    col.pszText = "Time";
    ListView_InsertColumn( listView, 3, &col );

    return cDialogBox::OnInitDialog( wparam, lparam );
  }

  virtual LRESULT OnDestroy( WPARAM wparam, LPARAM lparam ) {
    return 0;
  }

  void CenterDlg() {
    RECT WinRect, TabRect;

    GetWindowRect( GetDlgItem( GetParent( d_hwnd ), IDC_TAB1 ), &TabRect );
    GetWindowRect( GetParent( d_hwnd ), &WinRect );

    WinRect.left = TabRect.left - WinRect.left;
    WinRect.top = TabRect.top - WinRect.top - GetSystemMetrics( SM_CYCAPTION );

    TabCtrl_AdjustRect( GetDlgItem( GetParent( d_hwnd ), IDC_TAB1 ), FALSE, &WinRect );

    SetWindowPos( d_hwnd, HWND_TOP, WinRect.left, WinRect.top, 0, 0, SWP_NOSIZE );
  }

public:
  cClientsDlg() : cDialogBox() {}
  virtual ~cClientsDlg() {}

  void SetCommServerThread( cCommServerThread *pServer ) { d_pServer = pServer; }

  virtual void UpdateData() {
    if( !d_active ) return;
  }
};


#endif

