#if !defined( __TCLINKEDLIST_H )
#define __TCLINKEDLIST_H
#define WINDOWS_LEAN_AND_MEAN
#include <windows.h>
////////////////////////////////////////////////////////////////////////////////

template <class link> class tcLinkedList : public link {
protected:
  tcLinkedList        *d_pNext, *d_pPrev;

public:
  tcLinkedList() : link() {
    d_pNext = NULL;
    d_pPrev = NULL;
  }

  tcLinkedList( tcLinkedList<link> *pList ) : link() {
    d_pNext = NULL;
    d_pPrev = NULL;

    if( pList ) pList->Link( this );
  }

  virtual ~tcLinkedList() {
    UnLink();
  }


  inline tcLinkedList *GetNext() { return d_pNext; }
  inline tcLinkedList *GetPrev() { return d_pPrev; }
  inline void         SetNext( tcLinkedList *pNext ) { d_pNext = pNext; }
  inline void         SetPrev( tcLinkedList *pPrev ) { d_pPrev = pPrev; }


  void Link( tcLinkedList *newLink ) {
    newLink->d_pNext = d_pNext;
    newLink->d_pPrev = this;
    if( d_pNext ) d_pNext->d_pPrev = newLink;
    d_pNext = newLink;
  }

  void UnLink() {
    if( d_pNext ) d_pNext->d_pPrev = d_pPrev;
    if( d_pPrev ) d_pPrev->d_pNext = d_pNext;
    d_pNext = NULL;
    d_pPrev = NULL;
  }
};


template <class item> class tcLinkedListItterator {
protected:
  tcLinkedList<item> *d_pStart,
                     *d_pItem;

public:
  tcLinkedListItterator() {
    d_pStart = NULL;
    d_pItem = NULL;
  }

  
  virtual ~tcLinkedListItterator() {}


  void operator=( tcLinkedList<item> *pStart ) {
    d_pStart = pStart;
    d_pItem = d_pStart;
  }


  inline tcLinkedList<item> *operator()() {
    return d_pItem;
  }


  inline void operator++() {
    if( d_pItem ) d_pItem = d_pItem->GetNext();
  }


  inline void operator--() {
    if( d_pItem ) d_pItem = d_pItem->GetPrev();
  }

  // go to first item in linked list.
  inline void Rewind() {
    d_pItem = d_pStart;
  }


  // go to last item in linked list
  inline void Unwind() {
    if( !d_pItem ) d_pItem = d_pStart;
    if( !d_pItem ) return;
    while( d_pItem->GetNext() && d_pItem->GetNext() != d_pStart ) d_pItem = d_pItem->GetNext();
  }
};


#endif