/* Project: <misc>
 * File   : cWindow.cpp
 * Created: 06/10/98 Dan Royer
 * Notes  : 
 *   base cWindow class for win32 applications
 *   a copy of this should be in DirectX.dll
 */
#ifndef __CWINDOW_H
#include "cWindow.h"
#endif
////////////////////////////////////////////////////////////////////////////////
static LRESULT CALLBACK DefWndProc( HWND hwnd, unsigned int msg, WPARAM wparam, LPARAM lparam ) {
  LPCREATESTRUCT  lpcs;
  cWindow         *pWindow;
  
  pWindow = (cWindow *)GetWindowLong( hwnd, 0 );  // Pointer to the (C++ object that is the) window.
  if( !pWindow ) {
    if( msg == WM_CREATE ) {
      lpcs = (LPCREATESTRUCT)lparam;
      pWindow = (cWindow *)lpcs->lpCreateParams;
      SetWindowLong( hwnd, 0, (LONG)pWindow );

      return pWindow->WndProc( hwnd, msg, wparam, lparam );
    } else return DefWindowProc( hwnd, msg, wparam, lparam );  // this should never be called
  } else return pWindow->WndProc( hwnd, msg, wparam, lparam );
}
////////////////////////////////////////////////////////////////////////////////
cWindow::cWindow() {
  d_hwnd = NULL;
  d_hInstance = NULL;
  strcpy( d_szClassName, "DefClassName" );
  strcpy( d_szAppName, "DefAppName" );
}


cWindow::~cWindow() {}
////////////////////////////////////////////////////////////////////////////////
int cWindow::Init( HINSTANCE hInstance, char *pClassName ) {
  d_hInstance = hInstance;
  strcpy( d_szClassName, pClassName );

  // don't fuck with these
  // Reserve extra bytes for each instance of the window;  we'll use these bytes to store a pointer
  // to the cWindow object corresponding to the window.  The size of a 'this' pointer depends on the
  // memory model.
  d_wndClass.cbSize        = sizeof( WNDCLASSEX );
  d_wndClass.cbWndExtra    = sizeof( cWindow * );
  d_wndClass.lpfnWndProc   = (WNDPROC)::DefWndProc;

  // ok to mess with
  d_wndClass.hInstance     = d_hInstance;
  d_wndClass.lpszClassName = d_szClassName;
  d_wndClass.lpszMenuName  = NULL;
  d_wndClass.style         = CS_HREDRAW | CS_VREDRAW;
  d_wndClass.cbClsExtra    = 0;
  d_wndClass.hIcon         = NULL;
  d_wndClass.hIconSm       = NULL;
  d_wndClass.hCursor       = LoadCursor( NULL, IDC_ARROW );
  d_wndClass.hbrBackground = (HBRUSH)GetStockObject( WHITE_BRUSH );

  return 0;
}


int cWindow::Register() {
  if( !RegisterClassEx( &d_wndClass ) ) {
    if( !RegisterClass( (LPWNDCLASS)&d_wndClass.style ) ) return 1;
  }

  return 0;
}


int cWindow::Create( char *pAppName ) {
  strcpy( d_szAppName, pAppName );

  // Pass 'this' pointer in lpParam of CreateWindowEx().
  d_hwnd = CreateWindow( d_szClassName,
                         d_szAppName,
                         WS_OVERLAPPEDWINDOW,
                         CW_USEDEFAULT, 0, CW_USEDEFAULT, 0,
                         NULL,
                         NULL,
                         d_hInstance,
                         (LPSTR)this );
  if( !d_hwnd ) return 1;
  return 0;
}


BOOL cWindow::Show( int cmdShow ) {
  return ShowWindow( d_hwnd, cmdShow );
}


void cWindow::Update() {
  UpdateWindow( d_hwnd ); 
}


HWND cWindow::GetHandle() {
  return d_hwnd;
}


void cWindow::Destroy() {
  if( d_hwnd ) {
    DestroyWindow( d_hwnd );
    d_hwnd = NULL;
  }
}
////////////////////////////////////////////////////////////////////////////////
LRESULT CALLBACK cWindow::WndProc( HWND hwnd, unsigned int msg, WPARAM wparam, LPARAM lparam ) {
  switch( msg ) {
    case WM_CREATE:  return OnCreate( hwnd, wparam, lparam );
    case WM_INITDIALOG:  return OnInitDialog( wparam, lparam );
    case WM_SETCURSOR:  return OnSetCursor( wparam, lparam );
    case WM_ACTIVATE:  return OnActivate( wparam, lparam );
    case WM_SIZE:  return OnSize( wparam, lparam );
    case WM_MOVE:  return OnMove( wparam, lparam );
    case WM_PAINT:  return OnPaint( wparam, lparam );
    case WM_ERASEBKGND:  return OnEraseBkgnd( wparam, lparam );
    case WM_KEYDOWN:  return OnKeyDown( wparam, lparam );
    case WM_KEYUP:  return OnKeyUp( wparam, lparam );
    case WM_COMMAND:  return OnCommand( wparam, lparam );
    case WM_CLOSE:  return OnClose( wparam, lparam );
    case WM_DESTROY:  return OnDestroy( wparam, lparam );
    default:  return OnOther( msg, wparam, lparam );
  }
}


LRESULT cWindow::OnCreate( HWND hwnd, WPARAM wparam, LPARAM lparam ) {
  return DefWindowProc( hwnd, WM_CREATE, wparam, lparam );
}


LRESULT cWindow::OnInitDialog( WPARAM wparam, LPARAM lparam ) {
  return DefWindowProc( d_hwnd, WM_INITDIALOG, wparam, lparam );
}


LRESULT cWindow::OnSetCursor( WPARAM wparam, LPARAM lparam ) {
  return DefWindowProc( d_hwnd, WM_SETCURSOR, wparam, lparam );
}


LRESULT cWindow::OnActivate( WPARAM wparam, LPARAM lparam ) {
  return DefWindowProc( d_hwnd, WM_ACTIVATE, wparam, lparam );
}


LRESULT cWindow::OnSize( WPARAM wparam, LPARAM lparam ) {
  return DefWindowProc( d_hwnd, WM_SIZE, wparam, lparam );
}


LRESULT cWindow::OnMove( WPARAM wparam, LPARAM lparam ) {
  return DefWindowProc( d_hwnd, WM_MOVE, wparam, lparam );
}


LRESULT cWindow::OnPaint( WPARAM wparam, LPARAM lparam ) {
  return DefWindowProc( d_hwnd, WM_PAINT, wparam, lparam );
}


LRESULT cWindow::OnEraseBkgnd( WPARAM wparam, LPARAM lparam ) {
  return DefWindowProc( d_hwnd, WM_ERASEBKGND, wparam, lparam );
}


LRESULT cWindow::OnKeyDown( WPARAM wparam, LPARAM lparam ) {
  return DefWindowProc( d_hwnd, WM_KEYDOWN, wparam, lparam );
}


LRESULT cWindow::OnKeyUp( WPARAM wparam, LPARAM lparam ) {
  return DefWindowProc( d_hwnd, WM_KEYUP, wparam, lparam );
}


LRESULT cWindow::OnTimer( WPARAM wparam, LPARAM lparam ) {
  return DefWindowProc( d_hwnd, WM_TIMER, wparam, lparam );
}


LRESULT cWindow::OnCommand( WPARAM wparam, LPARAM lparam ) {
  return DefWindowProc( d_hwnd, WM_COMMAND, wparam, lparam );
}


LRESULT cWindow::OnClose( WPARAM wparam, LPARAM lparam ) {
  Destroy();
  return DefWindowProc( d_hwnd, WM_CLOSE, wparam, lparam );
}


LRESULT cWindow::OnDestroy( WPARAM wparam, LPARAM lparam ) {
  PostQuitMessage( 0 );
  return DefWindowProc( d_hwnd, WM_DESTROY, wparam, lparam );
}


LRESULT cWindow::OnOther( unsigned int msg, WPARAM wparam, LPARAM lparam ) {
  return DefWindowProc( d_hwnd, msg, wparam, lparam );
}
////////////////////////////////////////////////////////////////////////////////
// EOF /////////////////////////////////////////////////////////////////////////

