/* ZVIEWER: cMatrix4.cpp
 * Created: 21/11/1998 Dan Royer
 * matrix of order 4 used to store orientation and position in 3D vector space
 */
#ifndef __CMATRIX4_H
#include "cMatrix4.h"
#endif
////////////////////////////////////////////////////////////////////////////////

cVector4 operator *( const cVector3 &src, const cMatrix4 &trans ) {
  float x, y, z;

  // cVector3 has no d_w, so it is considered to be 1, which eliminates some work.
  x = src.d_x * trans.a00 + src.d_y * trans.a10 + src.d_z * trans.a20 + trans.a30;
  y = src.d_x * trans.a01 + src.d_y * trans.a11 + src.d_z * trans.a21 + trans.a31;
  z = src.d_x * trans.a02 + src.d_y * trans.a12 + src.d_z * trans.a22 + trans.a32;
  // cVector4.d_w stays = 1.

  return cVector4( x, y, z, 1.0f );
}


cVector4 operator *( const cVector4 &src, const cMatrix4 &trans ) {
  float x, y, z, w;

  x = src.d_x * trans.a00 + src.d_y * trans.a10 + src.d_z * trans.a20 + trans.a30 * src.d_w;
  y = src.d_x * trans.a01 + src.d_y * trans.a11 + src.d_z * trans.a21 + trans.a31 * src.d_w;
  z = src.d_x * trans.a02 + src.d_y * trans.a12 + src.d_z * trans.a22 + trans.a32 * src.d_w;
  w = src.d_x * trans.a03 + src.d_y * trans.a13 + src.d_z * trans.a23 + trans.a32 * src.d_w;

  return cVector4( x, y, z, w );
}

