/* Project: None
 * File   : cLog.cpp
 * Created: 18/01/99 Dan Royer
 * Notes  : 
 * The cLog class keeps a log of reported messages and when the in-ram buffer is
 * full it can output the oldest information to a file.
 */
#ifndef __CLOG_H
#include "cLog.h"
#endif
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdarg.h>
////////////////////////////////////////////////////////////////////////////////

cLog::cLog() {
  memset( d_logBuffer, 0, LOG_BUFFERLENGTH );
  memset( d_filename, 0, _MAX_PATH );
  d_fDump = NULL;
}


cLog::~cLog() {
  StopLogToFile();
}

// initialization & cleanup

void cLog::StartLogToFile( char *pFilename ) {
  if( !pFilename || d_fDump ) return;

  SYSTEMTIME time;

  d_fDump = fopen( pFilename, "wt" );
  if( !d_fDump ) Error( "DUMP FILE UNOPENED!" );
  Dump( -1 );  // dump the whole buffer
  LogNewLine();
  GetLocalTime( &time );
  Log( "Log file begun: %02d:%02d:%02d:%03d %02d/%02d/%04d\n",
    time.wHour, time.wMinute, time.wSecond, time.wMilliseconds, 
    time.wDay, time.wMonth, time.wYear );
  strcpy( d_filename, pFilename );
  LogNewLine();
}


void cLog::StopLogToFile() {
  if( !d_fDump ) return;

  SYSTEMTIME time;

  LogNewLine();
  GetLocalTime( &time );
  Log( "Log file ended: %02d:%02d:%02d:%03d %02d/%02d/%04d\n",
    time.wHour, time.wMinute, time.wSecond, time.wMilliseconds, 
    time.wDay, time.wMonth, time.wYear );
  LogNewLine();
  fclose( d_fDump );
  d_fDump = NULL;
}


// logging information 

void cLog::Log( char *pFormat, ... ) {
  char    buffer[ 2000 ];
  va_list arg;

  va_start( arg, pFormat );
  vsprintf( buffer, pFormat, arg );
  va_end( arg );

  if( strlen( d_logBuffer ) + strlen( buffer ) >= LOG_BUFFERLENGTH ) {
    unsigned int i;

    i = strlen( d_logBuffer ) + strlen( buffer ) + 1 - LOG_BUFFERLENGTH;
    strncpy( d_logBuffer, d_logBuffer + i, LOG_BUFFERLENGTH - i );
  }

#if defined( _DEBUG )
  OutputDebugString( buffer );
#endif
  if( d_fDump ) fwrite( buffer, sizeof( char ), strlen( buffer ), d_fDump );
  strcat( d_logBuffer, buffer );
}


void cLog::LogNewLine() {
  Log( "------------------------------\n" );
}


void cLog::Warning( char *pFormat, ... ) {
  char    buffer[ 300 ];
  va_list arg;

  va_start( arg, pFormat );
  vsprintf( buffer, pFormat, arg );
  va_end( arg );

  Log( "WARNING: %s", buffer );
}


void cLog::Error( char *pFormat, ... ) {
  char    buffer[ 300 ];
  va_list arg;

  va_start( arg, pFormat );
  vsprintf( buffer, pFormat, arg );
  va_end( arg );

  Log( "ERROR: %s", buffer );
}


/* Remove some of the log buffer data from memory.
 * Optionally it can be saved to a file.
 */
void cLog::Dump( unsigned int numBytes ) {
  // how much are we dumping?
  if( numBytes == -1 || strlen( d_logBuffer ) <= numBytes ) {  // dump all
    numBytes = strlen( d_logBuffer );
  }

  if( d_fDump ) fwrite( d_logBuffer, sizeof( char ), numBytes, d_fDump );

  if( numBytes == strlen( d_logBuffer ) ) {
    memset( d_logBuffer, 0, LOG_BUFFERLENGTH );
  } else {
    unsigned int i;

    i = strlen( d_logBuffer ) - numBytes;
    strncpy( d_logBuffer, d_logBuffer + numBytes, i );
    memset( d_logBuffer + i, 0, numBytes );
  }
}

