/* Project: <misc>
 * File   : cDialogBox.cpp
 * Created: 19/10/98 Dan Royer
 * Notes  : base cDialogBox class for win32 applications
 */
#ifndef __CDIALOGBOX_H
#include "cDialogBox.h"
#endif
#include <stdio.h>
////////////////////////////////////////////////////////////////////////////////
static LRESULT CALLBACK DefDialogProc( HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam ) {
  cDialogBox    *pDialogBox;
  CREATESTRUCT  *lpcs;

  pDialogBox = (cDialogBox *)GetWindowLong( hwnd, DWL_USER );  // Pointer to the (C++ object that is the) window.

  if( !pDialogBox ) {
    if( msg == WM_INITDIALOG ) {
      lpcs = (LPCREATESTRUCT)lparam;
      pDialogBox = (cDialogBox *)&lpcs->lpCreateParams;
      SetWindowLong( hwnd, DWL_USER, (LONG)pDialogBox );
      return pDialogBox->DlgProc( hwnd, msg, wparam, lparam );
    }
    // DefDlgProc would cause endless recursion & stack overflow
    return DefWindowProc( hwnd, msg, wparam, lparam );
  }
  return pDialogBox->DlgProc( hwnd, msg, wparam, lparam );
}
////////////////////////////////////////////////////////////////////////////////
cDialogBox::cDialogBox() {
  d_hwnd = NULL;
  d_hwndParent = NULL;
  d_hInstance = NULL;
  d_active = 0;
}


cDialogBox::~cDialogBox() {}
////////////////////////////////////////////////////////////////////////////////
int cDialogBox::Init( HINSTANCE hInstance, int templateId ) {
  d_hInstance = hInstance;
  d_templateId = templateId;

  return 0;
}


int cDialogBox::Create( HWND hwndParent ) {
  d_hwndParent = hwndParent;

  // Pass 'this' pointer in lpParam of CreateWindowEx().
  d_hwnd = CreateDialogParam( d_hInstance,
                              MAKEINTRESOURCE( d_templateId ),
                              d_hwndParent,
                              (DLGPROC)DefDialogProc,
                              (LPARAM)(LPSTR)this );
  if( !d_hwnd ) return 1;
  return 0;
}


BOOL cDialogBox::Show( int cmdShow ) {
  return ShowWindow( d_hwnd, cmdShow );
}


void cDialogBox::Update() {
  UpdateWindow( d_hwnd ); 
}


HWND cDialogBox::GetHandle() {
  return d_hwnd;
}


void cDialogBox::Destroy( int returnCode ) {
  d_active = 0;
  DestroyWindow( d_hwnd );
}
////////////////////////////////////////////////////////////////////////////////
LRESULT CALLBACK cDialogBox::DlgProc( HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam ) {
  switch( msg ) {
    case WM_INITDIALOG:
      d_hwnd = hwnd;
      d_active = 1;
      return OnInitDialog( wparam, lparam );
    case WM_SETCURSOR:  return OnSetCursor( wparam, lparam );
    case WM_ACTIVATE:  return OnActivate( wparam, lparam );
    case WM_SIZE:  return OnSize( wparam, lparam );
    case WM_MOVE:  return OnMove( wparam, lparam );
    case WM_PAINT:  return OnPaint( wparam, lparam );
    case WM_ERASEBKGND:  return OnEraseBkgnd( wparam, lparam );
    case WM_KEYDOWN:  return OnKeyDown( wparam, lparam );
    case WM_KEYUP:  return OnKeyUp( wparam, lparam );
    case WM_COMMAND:  return OnCommand( wparam, lparam );
    case WM_NOTIFY:  return OnNotify( wparam, lparam );
    case WM_CLOSE:  return OnClose( wparam, lparam );
    case WM_DESTROY:  return OnDestroy( wparam, lparam );
    default:  return OnOther( msg, wparam, lparam );
  }
}


LRESULT cDialogBox::OnInitDialog( WPARAM wparam, LPARAM lparam ) {
  return 0;
}


LRESULT cDialogBox::OnSetCursor( WPARAM wparam, LPARAM lparam ) {
  return 0;
}


LRESULT cDialogBox::OnActivate( WPARAM wparam, LPARAM lparam ) {
  return 0;
}


LRESULT cDialogBox::OnSize( WPARAM wparam, LPARAM lparam ) {
  return 0;
}


LRESULT cDialogBox::OnMove( WPARAM wparam, LPARAM lparam ) {
  return 0;
}


LRESULT cDialogBox::OnPaint( WPARAM wparam, LPARAM lparam ) {
  return 0;
}


LRESULT cDialogBox::OnEraseBkgnd( WPARAM wparam, LPARAM lparam ) {
  return 0;
}


LRESULT cDialogBox::OnKeyDown( WPARAM wparam, LPARAM lparam ) {
  return 0;
}


LRESULT cDialogBox::OnKeyUp( WPARAM wparam, LPARAM lparam ) {
  return 0;
}


LRESULT cDialogBox::OnTimer( WPARAM wparam, LPARAM lparam ) {
  return 0;
}


LRESULT cDialogBox::OnCommand( WPARAM wparam, LPARAM lparam ) {
  return 0;
}


LRESULT cDialogBox::OnNotify( WPARAM wparam, LPARAM lparam ) {
  return 0;
}


LRESULT cDialogBox::OnClose( WPARAM wparam, LPARAM lparam ) {
  DestroyWindow( d_hwnd );
  return 0;
}


LRESULT cDialogBox::OnDestroy( WPARAM wparam, LPARAM lparam ) {
  PostQuitMessage( 0 );
  return 0;
}


LRESULT cDialogBox::OnOther( UINT msg, WPARAM wparam, LPARAM lparam ) {
  return 0;
}
////////////////////////////////////////////////////////////////////////////////
void cDialogBox::EnableWindowItem( int itemId, int newState ) {
  EnableWindow( GetDlgItem( d_hwnd, itemId ), newState );
}
////////////////////////////////////////////////////////////////////////////////
// EOF /////////////////////////////////////////////////////////////////////////

