/* Project: DirectX Windows DLL
 * File   : CDInput.h
 * Created: 25/05/98 Dan Royer
 * Note   :
 */
#ifndef __CDINPUT_H
#define __CDINPUT_H
////////////////////////////////////////////////////////////////////////////////
#include <dinput.h>
////////////////////////////////////////////////////////////////////////////////

enum eDInputMsgs {
  ZVDI_OK = 0,
  ZVDI_ERROR,             // unspecified error
  ZVDI_MEMORY,            // no ram left

  ZVDI_INITFAILURE,
  ZVDI_ACQUIREFAILURE,
  ZVDI_UPDATEFAILURE,

  ZVDI_INVALIDPARAM,

  ZVDI_KEYUNBOUND,        // key not bound
  ZVDI_ACTIONUNBOUND,     // action not bound
  ZVDI_ACTIONNONEXISTENT };


enum eInputType { DI_INPUTKEYBD, DI_INPUTMOUSE, DI_INPUTJOYST };


// action state is set up like this for masking purposes
enum eActionState {
  ACTION_OFF = 0,
  ACTION_ON = 1,
  ACTION_ENDED = 2,  // ACTION_ENDED & 0x1 = 0
  ACTION_BEGUN = 3  // ACTION_BEGUN & 0x1 = 1
};
////////////////////////////////////////////////////////////////////////////////

struct cKeyId {
public:
  char            d_name[ 16 ];
  eInputType      d_inputType;
  int             d_id;
  char            d_ascii, d_asciiShift;
};


// Only used to query the status of an action.
struct cActionQuery {
public:
  char            d_name[ 16 ];  // name of action
  eActionState    d_state;
  DWORD           d_start;
};


/* Each action has one key.  This way each key can have many
 * actions associated to it and each action can have many keys.
 */
class cAction {
public:
  char            d_name[ 16 ];
  eActionState    d_state;  // active = 0 inactive = 1
  DWORD           d_start;
  cKeyId          *d_pKey;
  cAction         *d_pNext, *d_pPrev;

public:
  cAction() {
    memset( d_name, 0, sizeof( d_name ) );
    d_pNext = NULL;
    d_pPrev = NULL;
    d_pKey = NULL;
    d_start = 0;
    d_state = ACTION_OFF;
  }
  ~cAction() {
    if( d_pNext ) d_pNext->SetPrev( d_pPrev );
    if( d_pPrev ) d_pPrev->SetNext( d_pNext );
    d_pNext = NULL;
    d_pPrev = NULL;
  }

  inline void     SetNext( cAction *pNext ) { d_pNext = pNext; }
  inline cAction  *GetNext() { return d_pNext; }
  inline void     SetPrev( cAction *pPrev ) { d_pPrev = pPrev; }
  inline cAction  *GetPrev() { return d_pPrev; }
};


/* The general input control class for mice, keyboards and joysticks
 * Currently designed as a wrapper class for DirectInput for DirectX 6.0
 */
class cDInput {
  HWND                d_hwnd;
  HINSTANCE           d_hinst;
  HANDLE              d_mouseHandle;
  IDirectInput        *d_di;              // DirectInput interface
  IDirectInputDevice  *d_DIKeyboard,      // keyboard device interface
                      *d_DIMouse;         // mouse device interface
  bool                d_keybdAquired,    // has the keyboard been acquired?
                      d_mouseAquired,
                      d_keybdInitialized,
                      d_mouseInitialized;
  cAction             d_actions;  // root of linked list
  float               d_mouseScale;  // sensitivity

public:
  // Bad C++ - Privatize this data
  char                d_keybdData[ 2 ][ 256 ],
                      d_keySequence[ 100 ];
  long int            d_mouseData[ 7 ];  // buttons + directions

  cDInput();
  ~cDInput();

  int                 Init( HINSTANCE ownerInst, HWND ownerHwnd );

  int                 ReaquireAll();
  int                 UpdateAll();
  void                ReleaseAll();


  int                 KeyboardInit();
  int                 KeyboardUpdate();  // might be better protected
  int                 KeyboardReaquire();  // might be better protected
  void                KeyboardRelease();  // might be better protected


  int                 MouseInit( int exclusive = 0 );
  int                 MouseReaquire();  // might be better protected
  int                 MouseUpdate();  // might be better protected
  void                MouseRelease();  // might be better protected
  inline void         MouseSetScale( float scale ) { d_mouseScale = scale; }
  inline float        MouseGetScale() { return d_mouseScale; }


  int                 BindKeyToAction( char *pKeyStr, char *pActionStr );
  int                 UnBindKeyFromAction( char *pKeyStr, char *pActionStr );
  int                 UnBindKeyFromAll( char *pKeyStr );
  int                 UnBindAllFromAction( char *pActionStr );
  int                 UnBindAll();

  int                 QueryAction( cActionQuery *pQuery );
  int                 QueryInputDevice( cActionQuery *pQuery );
//  eActionState        QueryActionState( char *pActionStr );  // unimplemented
//  DWORD               QueryActionStart( char *pActionStr );  // unimplemented
};


#endif

