/* Project: DirectX Windows DLL
 * File   : cDDraw.h
 * Created: ??/04/98 Dan Royer
 */
#ifndef __CDDRAW_H
#define __CDDRAW_H
////////////////////////////////////////////////////////////////////////////////
#include <ddraw.h>
////////////////////////////////////////////////////////////////////////////////
//#define DD_USE_BACKBUFFER2  // Bad C++
////////////////////////////////////////////////////////////////////////////////
class cDDraw {
protected:
  HWND                  d_hwnd;
  LPDIRECTDRAW4         d_pDD4;
  DDSURFACEDESC2        d_ddsd;
  IDirectDrawClipper    *d_pClipper;  // windowed mode only
  IDirectDrawPalette    *d_pPalette;  // 256 color mode only
  IDirectDrawSurface4   *d_pFrontBuffer, *d_pBackBuffer, *d_pBackBuffer2;  // bb2 not used yet

  RECT                  d_windowSize, d_windowPos;  // only when windowed?

  unsigned int          d_width, d_height, d_pitch, d_bpp;
  float                 d_aspectX, d_aspectY;  // aspect ratios
  bool                  d_fullscreen, d_backLocked;
  unsigned short        *d_pBuff;

  virtual void          DestroyObjects();
  virtual int           CreateDevices( HWND hwnd, bool bFullScreen, GUID *pDriverGUID = NULL );
  virtual int           CreateSurfaces();
  virtual int           CreateClipper();
  virtual int           ChangeResolution( unsigned int width, unsigned int height, unsigned int bpp, bool bFullScreen );

public:
  cDDraw();
  virtual ~cDDraw();

  virtual int           Init( unsigned int width, unsigned int height, unsigned int bpp, bool bFullScreen, HWND hwnd );
  virtual void          Move();  // windowed mode only
  virtual bool          Resize( RECT *pPos, int bpp, bool fullscreen );  // windowed mode only

  void                  Lock();
  void                  Unlock();
  virtual void          Clear( bool dolock = 1 );  // clear and lock the surface
  virtual void          Render();

  virtual int           CheckSurfaceIntegrity();  // returns 0 on no problem or successful restore, else 1

  unsigned short        *GetBackSurfPtr() { return d_pBuff; }
  HRESULT               GetBackSurfDC( HDC *hdc ) { return d_pBackBuffer->GetDC( hdc ); }
  HRESULT               ReleaseBackSurfDC( HDC hdc ) { return d_pBackBuffer->ReleaseDC( hdc ); }
  LPDIRECTDRAW4         GetDD() { return d_pDD4; }

  unsigned int          GetWidth() { return d_width; }
  unsigned int          GetHeight() { return d_height; }
  unsigned int          GetBpp() { return d_bpp; }
  float                 GetAspectX() { return d_aspectX; }
  float                 GetAspectY() { return d_aspectY; }
};
////////////////////////////////////////////////////////////////////////////////
#endif
////////////////////////////////////////////////////////////////////////////////
// EOF /////////////////////////////////////////////////////////////////////////
