/* Project: DirectX Windows DLL
 * File   : cDInput.cpp
 * Created: 25/05/98 Dan Royer
 * Note   :
 *   will not work with cWindow (yet).  see Init()
 */
#ifndef __CDDRAW_H
#include "cDDraw.h"
#endif

#define WIN32_LEAN_AND_MEAN  // I don't know if this acutally helps with windowsx.h
#include <windowsx.h>  // GetWindowStyle(), GetWindowExStyle()

#if defined( _DEBUG )
#include <stdio.h>
#endif
////////////////////////////////////////////////////////////////////////////////
static const GUID IID_IDirectDraw4 = { 0x9c59509a,0x39bd,0x11d1,0x8c,0x4a,0x00,0xc0,0x4f,0xd9,0x30,0xc5 };
////////////////////////////////////////////////////////////////////////////////
cDDraw::cDDraw() {
  d_hwnd = NULL;
  d_pDD4 = NULL;
  d_pFrontBuffer = NULL;
  d_pBackBuffer = NULL;
  d_pBackBuffer2 = NULL;
  d_pClipper = NULL;
  d_pPalette = NULL;
//  d_pBuff = NULL;

  d_windowPos.top = 0;  // relative to screen
  d_windowPos.bottom = 0;
  d_windowPos.left = 0;
  d_windowPos.right = 0;

  d_windowSize.top = 0;  // relative to client window area
  d_windowSize.bottom = 0;
  d_windowSize.left = 0;
  d_windowSize.right = 0;

  d_backLocked = 0;
  d_fullscreen = 0;
  d_backLocked = 0;

  d_aspectX = 1;
  d_aspectY = 1;
}


cDDraw::~cDDraw() {
  DestroyObjects();
}
////////////////////////////////////////////////////////////////////////////////
int cDDraw::Init( unsigned int width, unsigned int height, unsigned int bpp, bool bFullScreen, HWND hwnd ) {
  // clean up if this is a mode change
  DestroyObjects();

  // for each of these functions that are part of cDDraw, the
  // error messages would be set up in those functions

  if( CreateDevices( hwnd, bFullScreen, NULL ) ) return 1;

  if( ChangeResolution( width, height, bpp, bFullScreen ) ) {
    DestroyObjects();
    return 2;
  }

  if( CreateSurfaces() ) {
    DestroyObjects();
    return 3;
  }

  if( !bFullScreen ) {
    if( CreateClipper() ) {
      DestroyObjects();
      return 4;
    }
  }

  return 0;
}


void cDDraw::DestroyObjects() {
  char    buffer[ 64 ];
  HRESULT result;

  if( d_pBackBuffer ) {
    result = d_pBackBuffer->Release();
#if defined( _DEBUG )
    if( result ) {
      sprintf( buffer, "d_pBackBuffer release = %d\n", result );
      OutputDebugString( buffer );
    }
#endif
    d_pBackBuffer = NULL;
  }
  if( d_pFrontBuffer ) {
    result = d_pFrontBuffer->Release();
#if defined( _DEBUG )
    if( result ) {
      sprintf( buffer, "d_pFrontBuffer release = %d\n", result );
      OutputDebugString( buffer );
    }
#endif
    d_pFrontBuffer = NULL;
  }
  if( d_pPalette ) {
    result = d_pPalette->Release();  // palettes
#if defined( _DEBUG )
    if( result ) {
      sprintf( buffer, "d_pPalette release = %d\n", result );
      OutputDebugString( buffer );
    }
#endif
    d_pPalette = NULL;
  }
  if( d_pClipper ) {
    result = d_pClipper->Release();
#if defined( _DEBUG )
    if( result ) {
      sprintf( buffer, "d_pClipper release = %d\n", result );
      OutputDebugString( buffer );
    }
#endif
    d_pClipper = NULL;
  }
  if( d_pDD4 ) {
	  if( d_fullscreen ) d_pDD4->SetCooperativeLevel( d_hwnd, DDSCL_NORMAL );
    result = d_pDD4->Release();
#if defined( _DEBUG )
    if( result ) {
      sprintf( buffer, "d_pDD4 release = %d\n", result );
      OutputDebugString( buffer );
    }
#endif
    d_pDD4 = NULL;
  }
}


int cDDraw::CreateDevices( HWND hwnd, bool bFullScreen, GUID *pDriverGUID ) {
  if( !hwnd ) return 1;

  int          flags;
  LPDIRECTDRAW lpDD;

  // for each of these functions that are part of cDDraw, the
  // error messages would be set up in those functions

  if( DirectDrawCreate( pDriverGUID, &lpDD, NULL ) != DD_OK ) return 2;

  if( lpDD->QueryInterface( IID_IDirectDraw4, (void **)&d_pDD4 ) != DD_OK ) {
    lpDD->Release();
    //  ErrorSetString( "DirectDraw initialization failed.", "cDDraw::CreateDevices()" );
    return 1;
  }
  lpDD->Release();

  // set up the cooperative level
  if( bFullScreen ) flags = DDSCL_EXCLUSIVE | DDSCL_ALLOWREBOOT | DDSCL_FULLSCREEN;
  else flags = DDSCL_NORMAL;

  if( d_pDD4->SetCooperativeLevel( hwnd, flags ) != DD_OK ) {
    //  ErrorSetString( "DirectDraw initialization fialed.", "cDDraw::CreateDevices()" );
    return 1;
  }

  d_hwnd = hwnd;

  return 0;
}


// change screen res/modify window properties
int cDDraw::ChangeResolution( unsigned int width, unsigned int height, UINT bpp, bool bFullScreen ) {
  DWORD           dwStyle;
  DDSURFACEDESC2  ddsd;

  memset( &ddsd, 1, sizeof( DDSURFACEDESC2 ) );
  ddsd.dwSize = sizeof( DDSURFACEDESC2 );

  // if no bpp was specified, set it to the current bpp.
  if( !bpp ) {
    d_pDD4->GetDisplayMode( &ddsd );
    bpp = ddsd.ddpfPixelFormat.dwRGBBitCount;
  }
  if( bpp <= 8 ) {
    //  ErrorSetString( "Bitdepth must be greater than 8.", "cDDraw::ChangeResolution()" );
    return 1;
  }

  if( bFullScreen ) {
    // if we are not a WS_POPUP window we should convert.
    dwStyle = GetWindowStyle( d_hwnd );
    dwStyle &= ~( WS_OVERLAPPED | WS_CAPTION | WS_THICKFRAME | WS_MINIMIZEBOX );
    dwStyle |= WS_POPUP;
    SetWindowLong( d_hwnd, GWL_STYLE, dwStyle );
    if( d_pDD4->SetDisplayMode( width, height, bpp, 0, 0 ) != DD_OK ) {
      //  ErrorSetString( "Display mode change failed.", "cDDraw::ChangeResolution()" );
      return 1;
    }
  } else {
    // Check the display mode, and prevent paletted window modes (8 bpp or less)
    d_pDD4->GetDisplayMode( &ddsd );
    if( ddsd.ddpfPixelFormat.dwRGBBitCount <= 8 )  {
      //  ErrorSetString( "Monitor bitdepth must be greater than 8.", "cDDraw::ChangeResolution()" );
      return 1;
    }
/*
    // use the current mode
    unsigned int currentBpp;

    hdc = ::GetDC( NULL );
    currentBpp = GetDeviceCaps( hdc, PLANES ) * GetDeviceCaps( hdc, BITSPIXEL );
    ::ReleaseDC( NULL, hdc );

    if( currentBpp < bpp ) {  // won't draw nicely
      //  ErrorSetString( "Requested bitdepth higher than monitor setting.", "cDDraw::ChangeResolution()" );
      return 1;
    }
*/
    // if we are still a WS_POPUP window we should convert to a
    // normal app window so we look like a windows app
    dwStyle = GetWindowStyle( d_hwnd );
    dwStyle &= ~WS_POPUP;
    dwStyle |= WS_OVERLAPPED | WS_CAPTION | WS_THICKFRAME | WS_MINIMIZEBOX;
    SetWindowLong( d_hwnd, GWL_STYLE, dwStyle );

    // set window size
    RECT rcWork, rc;

    SetRect( &rc, 0, 0, width, height );
    AdjustWindowRectEx( &rc, GetWindowStyle( d_hwnd ), (int)GetMenu( d_hwnd ), GetWindowExStyle( d_hwnd ) );
    SetWindowPos( d_hwnd, NULL, 0, 0, rc.right - rc.left, rc.bottom - rc.top, SWP_NOMOVE | SWP_NOZORDER | SWP_NOACTIVATE );
    SetWindowPos( d_hwnd, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE | SWP_NOACTIVATE );

    // Make sure our window does not hang outside of the work area
    // this will make people who have the tray on the top or left happy.
    SystemParametersInfo( SPI_GETWORKAREA, 0, &rcWork, 0 );
    GetWindowRect( d_hwnd, &rc );
    if( rc.left < rcWork.left ) rc.left = rcWork.left;
    if( rc.top < rcWork.top ) rc.top = rcWork.top;
    SetWindowPos( d_hwnd, NULL, rc.left, rc.top, 0, 0, SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE );
  }

  d_bpp = bpp;
  d_width = width;
  d_height = height;
  d_fullscreen = bFullScreen;

  if( width > height ) {
    d_aspectX = (float)height / (float)width;
    d_aspectY = 1.0f;
  } else {
    d_aspectX = 1.0f;
    d_aspectY = (float)width / (float)height;
  }

  return 0;
}


int cDDraw::CreateSurfaces() {
  DDBLTFX         ddbltfx;
  DDSCAPS2        scaps;
  DDSURFACEDESC2  ddsd;
  HRESULT         err;

  ZeroMemory( &ddsd, sizeof( DDSURFACEDESC2 ) );
  ddsd.dwSize = sizeof( DDSURFACEDESC2 );

  // Surfaces must be recreated for new display modes, they wont work if/when it is changed.
  if( d_fullscreen ) {
    ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | DDSCAPS_COMPLEX | DDSCAPS_VIDEOMEMORY;

    // we want a tripple buffered surface in video memory
    ddsd.dwBackBufferCount = 2;
    err = d_pDD4->CreateSurface( &ddsd, &d_pFrontBuffer, NULL );

    // cant get tripple buffered surface, try a double buffered surface (still in video memory)
    if( err != DD_OK ) {
      ddsd.dwBackBufferCount = 1;
      err = d_pDD4->CreateSurface( &ddsd, &d_pFrontBuffer, NULL );
    }
    // if we can't get a double buffered surface, try for a double buffered surface not 
    // being specific about video memory. we'll get a main memory surface that uses hardware
    // page flipping but at least we run
    if( err != DD_OK ) {
      ddsd.ddsCaps.dwCaps &= ~DDSCAPS_VIDEOMEMORY;
      err = d_pDD4->CreateSurface( &ddsd, &d_pFrontBuffer, NULL );
    }
    if( err != DD_OK ) return 1;

    // get a pointer to the back buffer
    scaps.dwCaps = DDSCAPS_BACKBUFFER;
    err = d_pFrontBuffer->GetAttachedSurface( &scaps, &d_pBackBuffer );
    if( err == DD_OK && ddsd.dwBackBufferCount == 2 ) {
      err = d_pFrontBuffer->GetAttachedSurface( &scaps, &d_pBackBuffer2 );
    }
    if( err != DD_OK ) {
      //  ErrorSetString( "Back buffer creation failed.", "cDDraw::CreateSurfaces()" );
      return 1;
    }
  } else {  // create the primary surface and create a backbuffer in offscreen memory
    ddsd.dwFlags = DDSD_CAPS;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;

    if( d_pDD4->CreateSurface( &ddsd, &d_pFrontBuffer, NULL ) != DD_OK )  {
      //  ErrorSetString( "Primary surface creation failed.", "cDDraw::CreateSurfaces()" );
      return 1;
    }

    ddsd.dwFlags = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT;	
    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
    ddsd.dwWidth = d_width;
    ddsd.dwHeight = d_height;

    if( d_pDD4->CreateSurface( &ddsd, &d_pBackBuffer, NULL ) != DD_OK )  {
      //  ErrorSetString( "Back buffer creation failed.", "cDDraw::CreateSurfaces()" );
      return 1;
    }
  }

  // Use the blitter to clear the buffers
  if( d_fullscreen ) {
    ddbltfx.dwSize = sizeof( DDBLTFX );
    ddbltfx.dwFillColor = 0;
    if( d_pFrontBuffer ) d_pFrontBuffer->Blt( NULL, NULL, NULL, DDBLT_COLORFILL | DDBLT_WAIT, &ddbltfx );
    if( d_pBackBuffer ) d_pBackBuffer->Blt( NULL, NULL, NULL, DDBLT_COLORFILL | DDBLT_WAIT, &ddbltfx );
    if( d_pBackBuffer2 ) d_pBackBuffer2->Blt( NULL, NULL, NULL, DDBLT_COLORFILL | DDBLT_WAIT, &ddbltfx );
  }

  return 0;
}


int cDDraw::CreateClipper() {
  // make sure we have all the prerequisites
  if( !d_pDD4 || !d_pFrontBuffer || !d_hwnd ) {
    //  ErrorSetString( "Function parameters missing.", "cDDraw::CreateClipper()" );
    return 1;
  }

  if( d_pDD4->CreateClipper( 0, &d_pClipper, NULL ) != DD_OK ) {
    //  ErrorSetString( "Clipper creation failed.", "cDDraw::CreateClipper()" );
    return 1;
  }
  if( d_pClipper->SetHWnd( 0, d_hwnd ) != DD_OK ) {
    //  ErrorSetString( "Clipper creation failed.", "cDDraw::CreateClipper()" );
    return 1;
  }
  if( d_pFrontBuffer->SetClipper( d_pClipper ) != DD_OK ) {
    //  ErrorSetString( "Clipper creation failed.", "cDDraw::CreateClipper()" );
    return 1;
  }

  return 0;
}


void cDDraw::Move() {
  // get the client rectangle
  if( d_fullscreen ) {
    SetRect( &d_windowPos, 0, 0, GetSystemMetrics( SM_CXSCREEN ), GetSystemMetrics( SM_CYSCREEN ) );
    memcpy( &d_windowSize, &d_windowPos, sizeof( RECT ) );
  } else {
    GetClientRect( d_hwnd, &d_windowSize );
	  GetClientRect( d_hwnd, &d_windowPos );
	  ClientToScreen( d_hwnd, (POINT *)&d_windowPos.left );  // top left
	  ClientToScreen( d_hwnd, (POINT *)&d_windowPos.right );  // bottom right
  }
}


bool cDDraw::Resize( RECT *pPos, int bpp, bool bFullscreen ) {
  // Bad C++ - Finish this!
  // cleanup and reinitialize to the new size

  // get the client rectangle
  if( bFullscreen ) {
    //SetRect( &d_windowPos, 0, 0, GetSystemMetrics( SM_CXSCREEN ), GetSystemMetrics( SM_CYSCREEN ) );
    pPos->left = 0;
    pPos->top = 0;
    memcpy( &d_windowSize, pPos, sizeof( RECT ) );
    memcpy( &d_windowPos, pPos, sizeof( RECT ) );
  } else {
    memcpy( &d_windowSize, pPos, sizeof( RECT ) );
    memcpy( &d_windowPos, pPos, sizeof( RECT ) );

    ClientToScreen( d_hwnd, (POINT *)&d_windowPos.left );  // top left
	  ClientToScreen( d_hwnd, (POINT *)&d_windowPos.right );  // bottom right
    d_width = d_windowPos.right - d_windowPos.left;
    d_height = d_windowPos.bottom - d_windowPos.top;

    DDSURFACEDESC2 ddsd;

    memset( &ddsd, 0, sizeof( DDSURFACEDESC2 ) );
    ddsd.dwSize = sizeof( DDSURFACEDESC2 );
    ddsd.dwFlags = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT;	
    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
    ddsd.dwWidth = d_width;
    ddsd.dwHeight = d_height;

    // recreate the back buffer.
    if( d_pBackBuffer ) {
      d_pBackBuffer->Release();
      d_pBackBuffer = NULL;
    }
    if( d_pFrontBuffer ) {
      if( d_pDD4->CreateSurface( &ddsd, &d_pBackBuffer, NULL ) != DD_OK )  {
//        ErrorSetString( "Back buffer creation failed.", "cDDraw::CreateSurfaces()" );
        OutputDebugString( "Backbuffer resize failed.\n" );
        return 1;
      }
    }
  }
  d_fullscreen = bFullscreen;
  d_bpp = bpp;

  if( d_windowSize.right > d_windowSize.bottom ) {
    d_aspectX = (float)d_windowSize.bottom / (float)d_windowSize.right;
    d_aspectY = 1.0f;
  } else {
    d_aspectX = 1.0f;
    d_aspectY = (float)d_windowSize.right / (float)d_windowSize.bottom;
  }

  return 0;
}


void cDDraw::Clear( bool doLock ) {
  DDBLTFX ddbltfx;

  d_pBuff = NULL;

  if( d_pFrontBuffer ) {
    if( d_pFrontBuffer->IsLost() == DDERR_SURFACELOST ) CheckSurfaceIntegrity();
  }// else return;  // Bad C++

  // use the blitter to do a color fill to clear the back buffer
  ddbltfx.dwSize = sizeof( DDBLTFX );
  ddbltfx.dwFillColor = 0;
  d_pBackBuffer->Blt( NULL, NULL, NULL, DDBLT_COLORFILL | DDBLT_WAIT, &ddbltfx );

  if( doLock ) Lock();
}


// lock the surface so we'll be ready to draw this frame
void cDDraw::Lock() {
  if( d_backLocked ) return;
  d_ddsd.dwSize = sizeof( d_ddsd );
  d_pBuff = NULL;
  if( d_pBackBuffer->Lock( NULL, &d_ddsd, DDLOCK_WAIT, NULL ) != DD_OK ) return;
  d_pBuff = (unsigned short *)d_ddsd.lpSurface;
  d_pitch = d_ddsd.lPitch;
  d_backLocked = 1;
}


void cDDraw::Unlock() {
  if( !d_backLocked ) return;
  d_pBackBuffer->Unlock( NULL );
  d_backLocked = 0;
}


void cDDraw::Render() {
  HRESULT ddrval;

  Unlock();

  if( d_fullscreen ) {
		while( 1 ) {
			ddrval = d_pFrontBuffer->Flip( NULL, 0 ); //DDFLIP_WAIT
			if( ddrval == DD_OK ) break;
			if( ddrval == DDERR_SURFACELOST /*&& !RestoreSurfaces()*/ ) return;
			if( ddrval != DDERR_WASSTILLDRAWING ) break;
		}
  } else ddrval = d_pFrontBuffer->Blt( &d_windowPos, d_pBackBuffer, NULL, DDBLT_WAIT, NULL );
}


// returns 0 on no problem or successful restore, else 1
int cDDraw::CheckSurfaceIntegrity() {
  if( d_pFrontBuffer && d_pFrontBuffer->IsLost() == DDERR_SURFACELOST ) {
    if( d_pFrontBuffer->Restore() != DD_OK ) return 1;
  }
  if( d_pBackBuffer && d_pBackBuffer->IsLost() == DDERR_SURFACELOST ) {
    if( d_pBackBuffer->Restore() != DD_OK ) return 2;
  }
  if( d_pBackBuffer2 && d_pBackBuffer2->IsLost() == DDERR_SURFACELOST ) {
    if( d_pBackBuffer2->Restore() != DD_OK ) return 3;
  }

  return 0;
}

