/* Project: Direct2D class
 * File   : cD2D.h
 * Created: 27/12/98 Dan Royer
 */
#ifndef __CD2D_H
#define __CD2D_H
////////////////////////////////////////////////////////////////////////////////
#ifndef __CDDRAW_H
#include "cDDraw.h"
#endif
#include <stdio.h>
////////////////////////////////////////////////////////////////////////////////
class cFont {
  IDirectDrawSurface4   *d_pBuffer;
  int                   d_width, d_height;
  cFont                 *d_pNext, *d_pPrev;

public:
  cFont();
  virtual ~cFont();

  bool                  Load( char *pFilename, int width, int height );
  bool                  Write( int x, int y, char *pText, int color = 0xFFFF, int style = 0 );
  int                   GetWidth() { return d_width; }
  int                   GetHeight() { return d_height; }

  cFont                 *GetNext() { return d_pNext; }
  cFont                 *GetPrev() { return d_pPrev; }
  void                  SetNext( cFont *pNext ) { d_pNext = pNext; }
  void                  SetPrev( cFont *pPrev ) { d_pPrev = pPrev; }
};


class cD2D : public cDDraw {
protected:
  cFont                 d_font;  // anchor
public:
  cD2D();
  virtual ~cD2D();

  virtual int           Init( unsigned int width, unsigned int height, unsigned int bpp, bool bFullScreen, HWND hwnd );
  virtual void          DestroyObjects();
  virtual int           CheckSurfaceIntegrity();

  inline long int       FixedCeil( long int inVal );  // could be private
  void                  DrawPixel( long x, long y, int r, int g, int b, int a );
  bool                  ClipLine();
  void                  DrawLine( long Ax, long Ay, long Bx, long By, int r, int g, int b, int a );

  void                  LoadPalette( char *pFilename );
  int                   SetColorKey( IDirectDrawSurface4 *pdds, short int colorKey );

  bool                  FontLoad( char *pFilename, int id );
  bool                  FontLoad( FILE *pFile );  // will read id number from file
  bool                  FontWrite( int x, int y, char *pText, int color, int id );

  // only applies to front buffer and back buffer(s)
  bool                  LoadBitmap( IDirectDrawSurface4 *pBuffer, char *filename, int width, int height );
  bool                  TakeScreenShot( char *pFilename );
  int                   CopyBitmapToSurface( IDirectDrawSurface4 *pdds, HBITMAP hbm, int x, int y, int dx, int dy );
  void                  DrawSurf( IDirectDrawSurface4 *source );
  HRESULT               Blit( RECT *srcrect, IDirectDrawSurface4 *src, RECT *destrect, int style );
  HRESULT               BltFast( int x, int y, IDirectDrawSurface4 *src, RECT *destrect, int style );
};


#endif

