/* Project: Direct2D class
 * File   : cD2D.cpp
 * Created: 27/12/98 Dan Royer
 * Note   :
 */
#ifndef __CD2D_H
#include "cD2D.h"
#endif
////////////////////////////////////////////////////////////////////////////////
//#define _DEBUG_LINEDRAW
////////////////////////////////////////////////////////////////////////////////

cD2D::cD2D() : cDDraw() {}
cD2D::~cD2D() {}
////////////////////////////////////////////////////////////////////////////////

int cD2D::Init( unsigned int width, unsigned int height, unsigned int bpp, bool bFullScreen, HWND hwnd ) {
  return cDDraw::Init( width, height, bpp, bFullScreen, hwnd );
}


void cD2D::DestroyObjects() {
  cDDraw::DestroyObjects();
}


// calls base class first
int cD2D::CheckSurfaceIntegrity() {
  if( cDDraw::CheckSurfaceIntegrity() ) return 1;

  // check integrity of all 2D related surfaces

  return 0;
}
////////////////////////////////////////////////////////////////////////////////

long int cD2D::FixedCeil( long int inVal ) {
  return ( inVal + 0xffff ) >> 16;
}


void cD2D::DrawPixel( long x, long y, int r, int g, int b, int a ) {
  // will be different for various pixel depths
  unsigned short *buf = d_pBuff + y * d_windowPos.right + x;

  switch( d_bpp /* + d_alpha */ ) {  // d_alpha = {128, 128}
    case 8:  break;  // ew...
    case 16:  *buf = ( r << 11 ) + ( g << 5 ) + b;  break;  // last bit not used
    case 24:  *buf = ( r << 16 ) + ( g << 8 ) + b; break;  // this is a guess
    case 32:  *buf = ( r << 20 ) + ( g << 10 ) + b; break;  // this is a guess
    case (128+8):  break;
    case (128+16):  *buf = ( a << 12 ) + ( r << 8 ) + ( g << 4 ) + b;  break;  // this is a guess
    case (128+24):  *buf = ( a << 18 ) + ( r << 12 ) + ( g << 6 ) + b;  break;  // this is a guess
    case (128+32):  *buf = ( a << 24 ) + ( r << 16 ) + ( g << 8 ) + b;  break;  // this is a guess
    default: break;
  }
}


void cD2D::DrawLine( long Ax, long Ay, long Bx, long By, int r, int g, int b, int a ) {
  long            dx, dy, x, fixed_slope;
  unsigned short  *pWriteBuffer, color;
  float           prestep, slope;
  int             j, bottom, top, width;

  if( !d_backLocked ) Lock();

  width = d_pitch / sizeof( unsigned short );

  switch( d_bpp /* + d_alpha */ ) {  // d_alpha = {0, 128}
    case 8:  break;  // ew...
    case 16:
      r >>= 3;
      g >>= 2;
      b >>= 3;
      color = ( r << 11 ) + ( g << 5 ) + b;  break;  // last bit not used
    case 24:  color = ( r << 16 ) + ( g << 8 ) + b;  break;  // this is a guess
    case 32:  color = ( r << 20 ) + ( g << 10 ) + b;  break;  // this is a guess
    case (128+8):  break;
    case (128+16):  color = ( a << 12 ) + ( r << 8 ) + ( g << 4 ) + b;  break;  // this is a guess
    case (128+24):  color = ( a << 18 ) + ( r << 12 ) + ( g << 6 ) + b;  break;  // this is a guess
    case (128+32):  color = ( a << 24 ) + ( r << 16 ) + ( g << 8 ) + b;  break;  // this is a guess
    default:  break;
  }

  if( Bx < Ax ) {
    j = Bx;
    Bx = Ax;
    Ax = j;
    j = By;
    By = Ay;
    Ay = j;
  }

  Ax <<= 16;
  Ay <<= 16;
  Bx <<= 16;
  By <<= 16;

  dx = Bx - Ax;
  dy = By - Ay;
#if defined( _DEBUG_LINEDRAW )
  FILE *test = fopen( "drawline.txt", "at" );
  fprintf( test, "-------------------------\n" );
  fprintf( test, "(%04d,%04d)-(%04d,%04d)\n", Ax >> 16, Ay >> 16, Bx >> 16, By >> 16 );
  fprintf( test, "d_width=%d\n", d_width );
  fprintf( test, "d_pitch=%d\n", width );
  fprintf( test, "d_height=%d\n", d_height );

  fprintf( test, "d_pBuff=%p\n", d_pBuff );
  fprintf( test, "Ay=%d (%d)\n", Ay >> 16, Ay );
  fprintf( test, "Ax=%d (%d)\n", Ax >> 16, Ax );
  fprintf( test, "offset=%d\n", width * ( Ay >> 16 ) + ( Ax >> 16 ) );
  fclose( test );
#endif

  if( !dy ) {
    top = (int)FixedCeil( Ax );
    bottom = (int)FixedCeil( Bx );
    pWriteBuffer = d_pBuff + width * ( Ay >> 16 ) + ( Ax >> 16 );
    for( j = top; j <= bottom; j++ ) *pWriteBuffer++ = color;
  } else if( !dx ) {
    if( By < Ay ) {
      j = By;
      By = Ay;
      Ay = j;
    }
    top = (int)FixedCeil( Ay );
    bottom = (int)FixedCeil( By );

  // rendering only works correctly when the view is at a !( width % 32 )
    pWriteBuffer = d_pBuff + width * ( Ay >> 16 ) + ( Ax >> 16 );
    for( j = top; j <= bottom; j++ ) {
      *pWriteBuffer = color;
      pWriteBuffer += width;
    }
  } else if( abs( dy ) > dx ) {
    if( By < Ay ) {
      top = (int)FixedCeil( By );
      bottom = (int)FixedCeil( Ay );
    } else {
      top = (int)FixedCeil( Ay );
      bottom = (int)FixedCeil( By );
    }

    slope = (float)dx / (float)dy;
    fixed_slope = (long)( slope * 65536.0 );
    prestep = (float)( top - ( Ay / 65536.0 ) );

    x = Ax + (int)( slope * prestep * 65536.0 ) + 0xffff;

    for( j = top; j <= bottom; j++ ) {
      pWriteBuffer = d_pBuff + width * j + ( x >> 16 );
      *pWriteBuffer = color;
      x += fixed_slope;
    }
  } else {
    top = (int)FixedCeil( Ax );
    bottom = (int)FixedCeil( Bx );

    slope = (float)dy / (float)dx;
    fixed_slope = (long)( slope * 65536.0 );
    prestep = (float)( top - ( Ax / 65536.0 ) );

    x = Ay + (int)( slope * prestep * 65536.0 ) + 0xffff;

    for( j = top; j <= bottom; j++ ) {
      pWriteBuffer = d_pBuff + width * ( x >> 16 ) + j;
      *pWriteBuffer = color;
      x += fixed_slope;
    }
  }
}


bool cD2D::ClipLine() {
  // Bad C++ - finish this!
  return 1;
}
////////////////////////////////////////////////////////////////////////////////
// this is not needed if the screen res is > 8 bpp
void cD2D::LoadPalette( char *filename ) {
  PALETTEENTRY ape[ 256 ];

  // load palette into ape

  d_pDD4->CreatePalette( DDPCAPS_8BIT, ape, &d_pPalette, NULL );
/*
  // Create and set the palette
  g_pDDPal = DDLoadPalette(g_pDD, szBitmap);
  if(g_pDDPal) g_pDDSPrimary->SetPalette(g_pDDPal);
*/
}


int cD2D::SetColorKey( IDirectDrawSurface4 *pDDSurface, short int colorkey ) {
  DDCOLORKEY ddck;

  ddck.dwColorSpaceLowValue  = colorkey;
  ddck.dwColorSpaceHighValue = ddck.dwColorSpaceLowValue;

  return pDDSurface->SetColorKey( DDCKEY_SRCBLT, &ddck );
}
////////////////////////////////////////////////////////////////////////////////

bool cD2D::LoadBitmap( IDirectDrawSurface4 *pBuffer, char *filename, int width, int height ) {
  HBITMAP hbm;

  if( !pBuffer ) return 1;

  hbm = (HBITMAP)LoadImage( GetModuleHandle( NULL ), filename, IMAGE_BITMAP, 0, 0, LR_CREATEDIBSECTION );
  if( !hbm ) hbm = (HBITMAP)LoadImage( NULL, filename, IMAGE_BITMAP, 0, 0, LR_CREATEDIBSECTION | LR_LOADFROMFILE );
  if( !hbm ) return 1;
  if( CopyBitmapToSurface( pBuffer, hbm, 0, 0, width, height ) ) {
    DeleteObject( hbm );
    return 1;
  }
  DeleteObject( hbm );

  return 0;
}


bool cD2D::TakeScreenShot( char *pFilename ) {
  return 0;
}


// Copied right out of Microsoft DirectX file ddutil.cpp
int cD2D::CopyBitmapToSurface( IDirectDrawSurface4 *pDDSurface, HBITMAP hbm, int x, int y, int dx, int dy ) {
  HDC                 hdcImage, hdc;
  DDSURFACEDESC2      desc;
  BITMAP              bm;
  HRESULT             hr;

  if( !hbm || !pDDSurface ) return 1;

  if( pDDSurface->IsLost() == DDERR_SURFACELOST ) CheckSurfaceIntegrity();

  // select bitmap into a memoryDC so we can use it
  hdcImage = CreateCompatibleDC( NULL );
  if( !hdcImage ) return 2;
  SelectObject( hdcImage, hbm );

  // get size of the bitmap
  GetObject( hbm, sizeof( bm ), &bm );  // get size of bitmap
  if( !dx ) dx = bm.bmWidth;  // use the passed size, unless zero
  if( !dy ) dy = bm.bmHeight;

  // get size of surface
  desc.dwSize = sizeof( desc );
  desc.dwFlags = DDSD_HEIGHT | DDSD_WIDTH;
  pDDSurface->GetSurfaceDesc( &desc );

  if( ( hr = pDDSurface->GetDC( &hdc ) ) == DD_OK ) {
	  StretchBlt( hdc, 0, 0, desc.dwWidth, desc.dwHeight, hdcImage, x, y, dx, dy, SRCCOPY );
	  pDDSurface->ReleaseDC( hdc );
  }

  DeleteDC( hdcImage );

  return 0;
}


void cD2D::DrawSurf( IDirectDrawSurface4 *source ) {
  RECT rect;

  if( d_pBackBuffer->IsLost() == DDERR_SURFACELOST ) d_pBackBuffer->Restore();
  if( source->IsLost() == DDERR_SURFACELOST ) source->Restore();

  rect.top = 0;
  rect.left = 0;
  rect.right = d_width;
  rect.bottom = d_height;
  d_pBackBuffer->BltFast( 0, 0, source, &rect, FALSE );

  Render();
}


HRESULT cD2D::Blit( RECT *srcrect, IDirectDrawSurface4 *src, RECT *destrect, int style ) {
  DDBLTFX ddbltfx;

  ddbltfx.dwSize = sizeof( ddbltfx );
  return d_pBackBuffer->Blt( srcrect, src, destrect, style, &ddbltfx );
}


HRESULT cD2D::BltFast( int x, int y, IDirectDrawSurface4 *src, RECT *destrect, int style ) {
  HRESULT ddrval;

  while( 1 ) {
    ddrval = d_pBackBuffer->BltFast( x, y, src, destrect, style );
    if( ddrval == DD_OK ) return ddrval;
    if( ddrval == DDERR_SURFACELOST /*&& !RestoreSurfaces()*/ ) return ddrval;
    if( ddrval != DDERR_WASSTILLDRAWING ) return ddrval;
  }
}


bool cD2D::FontLoad( char *pFilename, int id ) {
  return 1;
}


bool cD2D::FontLoad( FILE *pFile ) {  // will read id number from file
  return 1;
}


bool cD2D::FontWrite( int x, int y, char *pText, int color, int id ) {
  HDC hdc;
  int locked;

  if( !d_pBackBuffer ) return 1;

  if( d_backLocked ) {
    Unlock();
    locked = 1;
  } else locked = 0;

  // Get a DC for the surface, then write pText.
  if( SUCCEEDED( d_pBackBuffer->GetDC( &hdc ) ) ) {
    SetTextColor( hdc, RGB( 255, 255, 255 ) );
    SetBkMode( hdc, TRANSPARENT );
    ExtTextOut( hdc, x, y, 0, NULL, pText, strlen( pText ), NULL );

    d_pBackBuffer->ReleaseDC( hdc );
  }
  if( locked ) Lock();

  return 0;
}
////////////////////////////////////////////////////////////////////////////////
// FONT material
////////////////////////////////////////////////////////////////////////////////

cFont::cFont() {
  d_pBuffer = NULL;
  d_width = 0;
  d_height = 0;
}


cFont::~cFont() {
  if( d_pNext ) d_pNext->SetPrev( d_pPrev );
  if( d_pPrev ) d_pPrev->SetNext( d_pNext );
}
////////////////////////////////////////////////////////////////////////////////

// font name, dimensions of a single character
bool cFont::Load( char *pFilename, int height, int width ) {
  // the bitmaps are arranged as a set of 8x32 tiled letters (totalling 256)
  // The fonts should be greyscale and no font may be bigger than 20 pixels
  // wide because DirectX gets really stupid about some buffers that are
  // greater than the screen width.
  if( width > 40 ) return 1;

  d_width = width;
  d_height = height;
//  LoadBitmap( d_pBuffer, pFilename, width * 8, height * 32 );

  return 0;
}


bool cFont::Write( int x, int y, char *pText, int color, int style ) {
  return 0;
}

