#ifndef __CCONSOLE_H
#include "cConsole.h"
#endif
#include <stdarg.h>
////////////////////////////////////////////////////////////////////////////////
//#define _DEBUG_CONSOLE
////////////////////////////////////////////////////////////////////////////////
// constructor & destructor
////////////////////////////////////////////////////////////////////////////////

cConsole::cConsole() {
  d_state = 0;
  d_offx = 32;
  d_offy = 32;
  d_width = 0;
  d_height = 0;
  d_lines = 0;
  d_columns = 0;
  d_pD2D = NULL;
  d_pLog = NULL;
}


cConsole::~cConsole() {
  d_pD2D = NULL;
}
////////////////////////////////////////////////////////////////////////////////
// initialization, resizing & management
////////////////////////////////////////////////////////////////////////////////

int cConsole::Init( cD2D *pD2D, cLog *pLog ) {
  d_pD2D = pD2D;
  d_pLog = pLog;

  RECT rect;

  rect.left = 0;
  rect.top = 0;
  rect.right = d_pD2D->GetWidth();
  rect.bottom = d_pD2D->GetHeight();

  Resize( &rect );

  return 0;
}


int cConsole::Resize( RECT *pos ) {
  d_width = ( pos->right - pos->left ) - d_offx * 2;
  d_height = ( pos->bottom - pos->top ) - d_offy * 2;
  d_columns = ( d_width >> 3 ) - 1;
  d_lines = ( d_height >> 4 ) - 1;

  return 0;
}
////////////////////////////////////////////////////////////////////////////////
// rendering
////////////////////////////////////////////////////////////////////////////////

void cConsole::Render( char *pText ) {
  if( !d_state ) return;  // don't draw!

  // Draw a semi transparent grey rectangle that
  // is centered and 90% of the window size.
  RECT pos;

  pos.left = d_offx + 1;
  pos.top = d_offy + 1;
  pos.right = d_offx + d_width - 1;
  pos.bottom = d_offy + d_height - 1;

  // Draw console information within the limits
  // of the greyed area - a small border
  // Bad C++ - limit the length of each line of text so that it stays within the boundaries
  char         *ptr, *pSrc, buffer[ 300 ];
  unsigned int i, j, start, bottom;

  // count all strings separated by \n
  i = 1;
  pSrc = d_pLog->GetBuffer();
  for( ptr = pSrc + strlen( pSrc ); ptr != pSrc; ptr-- ) {
    if( *ptr == '\n' ) {
      if( ++i >= d_lines ) break;
    }
  }
  i++;
  pSrc = ptr;
  bottom = d_offy + ( d_lines - i ) * 16;

  // write i strings
  for( j = 1; j < i; j++ ) {
    ptr = strchr( pSrc, '\n' );
    if( !ptr ) ptr = pSrc + strlen( pSrc );
    strncpy( buffer, pSrc, ptr - pSrc );
    buffer[ ptr - pSrc ] = '\0';
    pSrc = ptr + 1;
    d_pD2D->FontWrite( d_offx + 4, bottom, buffer, 0, 0 );
    bottom += 16;
  }

  if( !pText ) return;  // don't draw!

  start = d_offx + 4;
  if( strlen( pText ) < d_columns - 1 ) {
    d_pD2D->FontWrite( start, bottom, ">", 0, 0 );
    start += 8;
    d_pD2D->FontWrite( start, bottom, pText, 0, 0 );
  } else d_pD2D->FontWrite( start, bottom, pText + strlen( pText ) - ( d_columns - 1 ), 0, 0 );
}

