/* Project: <misc>
 * File   : cWindow.h
 * Created: 07/10/98 Dan Royer
 */
////////////////////////////////////////////////////////////////////////////////
#ifndef __CWINDOW_H
#define __CWINDOW_H
////////////////////////////////////////////////////////////////////////////////
#define WIN32_LEAN_AND_MEAN

#include <windows.h>
////////////////////////////////////////////////////////////////////////////////
class cWindow {
protected:
  HWND              d_hwnd;
  HINSTANCE         d_hInstance;
  WNDCLASSEX        d_wndClass;
  char              d_szClassName[ 64 ],
                    d_szAppName[ 64 ];

  virtual LRESULT   OnCreate( HWND hwnd, WPARAM wparam, LPARAM lparam );  // WM_CREATE
  virtual LRESULT   OnInitDialog( WPARAM wparam, LPARAM lparam );  // WM_INITDIALOG
  virtual LRESULT   OnSetCursor( WPARAM wparam, LPARAM lparam );  // WM_SETCURSOR
  virtual LRESULT   OnActivate( WPARAM wparam, LPARAM lparam );  // WM_ACTIVATE
  virtual LRESULT   OnSize( WPARAM wparam, LPARAM lparam );  // WM_SIZE
  virtual LRESULT   OnMove( WPARAM wparam, LPARAM lparam );  // WM_MOVE
  virtual LRESULT   OnPaint( WPARAM wparam, LPARAM lparam );  // WM_PAINT
  virtual LRESULT   OnEraseBkgnd( WPARAM wparam, LPARAM lparam );  // WM_ERASEBKGND
  virtual LRESULT   OnKeyDown( WPARAM wparam, LPARAM lparam );  // WM_KEYDOWN
  virtual LRESULT   OnKeyUp( WPARAM wparam, LPARAM lparam );  // WM_KEYUP
  virtual LRESULT   OnTimer( WPARAM wparam, LPARAM lparam );  // WM_TIMER
  virtual LRESULT   OnCommand( WPARAM wparam, LPARAM lparam );  // WM_COMMAND
  virtual LRESULT   OnClose( WPARAM wparam, LPARAM lparam );  // WM_CLOSE
  virtual LRESULT   OnDestroy( WPARAM wparam, LPARAM lparam );  // WM_DESTROY
  virtual LRESULT   OnOther( unsigned int msg, WPARAM wparam, LPARAM lparam );  // anything else

public:
  cWindow();
  virtual ~cWindow();

  int               Init( HINSTANCE hInstance, char *pClassName );
  int               Register();
  int               Create( char *pAppName );
  BOOL              Show( int cmdShow );
  void              Update();
  void              Destroy();

  HWND              GetHandle();

  LRESULT CALLBACK  WndProc( HWND hwnd, unsigned int MSG, WPARAM wparam, LPARAM lparam );
};
////////////////////////////////////////////////////////////////////////////////
#endif
////////////////////////////////////////////////////////////////////////////////
// EOF /////////////////////////////////////////////////////////////////////////

