#if !defined( __CPATCH_H )
#include "cPatch.h"
#endif
////////////////////////////////////////////////////////////////////////////////

cPatch::cPatch() {
  d_lod = 0;
  d_changed = 0;
  d_pPolygons = NULL;
  d_pPoints = NULL;
  LOD( 8 );
}


cPatch::~cPatch() {
  delete [] d_pPolygons;
  delete [] d_pPoints;
}
////////////////////////////////////////////////////////////////////////////////

void cPatch::LOD( int amnt ) {
  d_lod += amnt;
  if( d_lod < PATCH_MINLOD ) {
    d_lod = PATCH_MINLOD;
    return;
  } else if( d_lod > PATCH_MAXLOD ) {
    d_lod = PATCH_MAXLOD;
    return;
  }

  // delete and then reallocate new arrays
  delete [] d_pPolygons;
  delete [] d_pPoints;

  d_pPolygons = new cPoly[ d_lod * d_lod * 2 ];
  d_pPoints = new cVector3[ ( d_lod + 1 ) * ( d_lod + 1 ) ];
  if( !d_pPolygons || !d_pPoints ) return;

  int   i, j;
  cPoly *pPoly;

  // associate points to polygons
  for( i = 0; i < d_lod; i++ ) {
    for( j = 0; j < d_lod; j++ ) {
      pPoly = &d_pPolygons[ i * ( d_lod * 2 ) + ( j * 2 ) ];
      pPoly->d_pPoints[ 0 ] = &d_pPoints[ ( i     ) * ( d_lod + 1 ) + ( j     ) ];
      pPoly->d_pPoints[ 1 ] = &d_pPoints[ ( i     ) * ( d_lod + 1 ) + ( j + 1 ) ];
      pPoly->d_pPoints[ 2 ] = &d_pPoints[ ( i + 1 ) * ( d_lod + 1 ) + ( j + 1 ) ];
      pPoly = &d_pPolygons[ i * ( d_lod * 2 ) + ( j * 2 ) + 1 ];
      pPoly->d_pPoints[ 0 ] = &d_pPoints[ ( i + 1 ) * ( d_lod + 1 ) + ( j + 1 ) ];
      pPoly->d_pPoints[ 1 ] = &d_pPoints[ ( i + 1 ) * ( d_lod + 1 ) + ( j     ) ];
      pPoly->d_pPoints[ 2 ] = &d_pPoints[ ( i     ) * ( d_lod + 1 ) + ( j     ) ];
    }
  }
  d_changed = 1;
}


// Three control point Bezier interpolation
// mu ranges from 0 to 1, start to end of the curve
cVector3 cPatch::Bezier3( cVector3 p1, cVector3 p2, cVector3 p3, float t ) {
   float tm1, tm12, t2;

   t2 = t * t;
   tm1 = 1.0f - t;
   tm12 = tm1 * tm1;
   tm1 *= t * 2.0f;

   return cVector3( p1.d_x * tm12 + p2.d_x * tm1 + p3.d_x * t2,
                    p1.d_y * tm12 + p2.d_y * tm1 + p3.d_y * t2,
                    p1.d_z * tm12 + p2.d_z * tm1 + p3.d_z * t2 );
}


void cPatch::Update( cD2D *pD2D, cMatrix4 *pMat ) {
  cVector3  controls[ 3 ];
  float     t, t2, dt;
  int       i, j;

  if( d_changed ) {
    d_changed = 0;

    for( i = 0; i < 6; i++ ) d_controlPoints[ i ] += d_controlVel[ i ];

    dt = 1.0f / (float)d_lod;

    t = 0.0f;
    for( i = 0; i < d_lod + 1; i++ ) {
      controls[ 0 ] = Bezier3( d_controlPoints[ 0 ], d_controlPoints[ 3 ], d_controlPoints[ 6 ], t );
      controls[ 1 ] = Bezier3( d_controlPoints[ 1 ], d_controlPoints[ 4 ], d_controlPoints[ 7 ], t );
      controls[ 2 ] = Bezier3( d_controlPoints[ 2 ], d_controlPoints[ 5 ], d_controlPoints[ 8 ], t );
      t2 = 0.0f;
      d_pPoints[ i * ( d_lod + 1 ) ] = controls[ 0 ];
      for( j = 0; j < d_lod; j++ ) {
        d_pPoints[ i * ( d_lod + 1 ) + j ] = Bezier3( controls[ 0 ], controls[ 1 ], controls[ 2 ], t2 );
        t2 += dt;
      }
      d_pPoints[ i * ( d_lod + 1 ) + j ] = controls[ 2 ];
      t += dt;
    }

    cVector3 normal, color;

    for( i = 0; i < d_lod * d_lod * 2; i++ ) {
      normal = d_pPolygons[ i ].BuildNormal();
 
      // color
      color.Position( 0, 0, 0 );

      if( normal.d_z > 0 ) {
        if( normal.d_x > 0 ) {
               color.d_r += normal.d_x * 256.0f;
               color.d_g += normal.d_x * 64.0f;
        } else color.d_g += -normal.d_x * 128.0f;
        if( normal.d_y < 0 ) {
               color.d_b += -normal.d_y * 256.0f;
               color.d_g += -normal.d_y * 64.0f;
        } else color.d_g += normal.d_y * 128.0f;
        if( normal.d_z >= 0.5f ) {
          color.d_g += ( normal.d_z - 0.5f ) * 196.0f;
          color.d_r += ( normal.d_z - 0.5f ) * 196.0f;
          color.d_b += ( normal.d_z - 0.5f ) * 196.0f;
        }
      }
      if( color.d_r < 0 ) color.d_r = 0;
      else if( color.d_r > 255 ) color.d_r = 255;
      if( color.d_g < 0 ) color.d_g = 0;
      else if( color.d_g > 255 ) color.d_g = 255;
      if( color.d_b < 0 ) color.d_b = 0;
      else if( color.d_b > 255 ) color.d_b = 255;

      d_pPolygons[ i ].SetColor( color );
    }
  }

  for( i = 0; i < d_lod * d_lod * 2; i++ ) {
    d_pPolygons[ i ].TransformProject( pD2D, pMat );
  }
}


void cPatch::Render( cD2D *pD2D ) {
  cPoly *pPoly;
  int   i, j, k;

  // Render the polygons
  // There's a hell of a lot of overdraw here...
  for( i = 0; i < d_lod * d_lod * 2; i++ ) {
    pPoly = &d_pPolygons[ i ];

    if( pPoly->GetClipped() ) continue;

    // - 1 removes diagonal line (3rd side of polygon).
    for( j = 0; j < pPoly->GetNumPoints() - 1; j++ ) {
      k = ( j + 1 ) % pPoly->GetNumPoints();
      pD2D->DrawLine( (long)pPoly->d_screenPoints[ j ].d_x, (long)pPoly->d_screenPoints[ j ].d_y,
                      (long)pPoly->d_screenPoints[ k ].d_x, (long)pPoly->d_screenPoints[ k ].d_y,
                      (int)pPoly->GetColor().d_r, (int)pPoly->GetColor().d_g, (int)pPoly->GetColor().d_b,
                      (int)0xff );
    }
  }

  // Render the bounding box?
}

/*
// Four control point Bezier interpolation
// mu ranges from 0 to 1, start to end of curve
cVector3 Bezier4( cVector3 p1, cVector3 p2, cVector3 p3, cVector3 p4, double t ) {
   double   tm1, tm13, t3;
   cVector3 p;

   tm1 = 1.0f - t;
   tm13 = tm1 * tm1 * tm1;
   t3 = t * t * t;

   p = tm13 * p1 + 3.0f * t * tm1 * tm1 * p2 + 3.0f * t * t * tm1 * p3 + t3 * p4;

   return p;
}


// General Bezier curve
// Number of control points is n+1
// 0 <= mu < 1    IMPORTANT, the last point is not computed
cVector3 Bezier( cVector3 *p, int n, double t ) {
   double   blend, tk, tnk;
   int      k, kn, nn, nkn;
   cVector3 b;

   tk = 1;
   tnk = pow( 1 - t,(double)n );

   for (k=0;k<=n;k++) {
      nn = n;
      kn = k;
      nkn = n - k;
      blend = tk * tnk;
      tk *= t;
      tnk /= ( 1 - t );
      while (nn >= 1) {
         blend *= nn;
         nn--;
         if (kn > 1) {
            blend /= (double)kn;
            kn--;
         }
         if (nkn > 1) {
            blend /= (double)nkn;
            nkn--;
         }
      }
      b += p[ k ] * blend;
   }

   return b;
}
*/