#if !defined( __COPTIONSDIALOG_H )
#define __COPTIONSDIALOG_H
////////////////////////////////////////////////////////////////////////////////
#if !defined( __CDIALOGBOX_H )
#include "cDialogBox.h"
#endif
////////////////////////////////////////////////////////////////////////////////

class cOptionsDialog : public cDialogBox {
protected:
  int             d_ip[ 4 ], d_port;
  char            d_login[ 32 ],
                  d_pass[ 32 ];
  bool            d_cancel;

  virtual LRESULT OnInitDialog( WPARAM wparam, LPARAM lparam );
  virtual LRESULT OnDestroy( WPARAM wparam, LPARAM lparam );
  virtual LRESULT OnCommand( WPARAM wparam, LPARAM lparam );
  virtual LRESULT OnClose( WPARAM wparam, LPARAM lparam );

  void            OnConnect();
  void            OnCancel();

public:
  cOptionsDialog();
  virtual ~cOptionsDialog();

  // It is never good form to put method bodies in header files.
  // Any change requires recompiling everything that inherit this file.
  int             GetIP( int part ) {
    if( part >= 0 && part < 4 ) return d_ip[ part ];
    return 0;
  }


  int             GetPort() { return d_port; }
  char            *GetLogin() { return d_login; }
  char            *GetPass() { return d_pass; }
  bool            GetCancel() { return d_cancel; }
};


#endif

