/* NETWORK CLIENT: cOptionsDialog.cpp
 * Created 23/06/99 Dan Royer
 * Connection options dialog for the network client
 */
#if !defined( __COPTIONSDIALOG_H )
#include "cOptionsDialog.h"
#endif
#include <commctrl.h>
#include "resource.h"
////////////////////////////////////////////////////////////////////////////////

cOptionsDialog::cOptionsDialog() : cDialogBox() {
  d_ip[ 0 ] = 24;
  d_ip[ 1 ] = 112;
  d_ip[ 2 ] = 84;
  d_ip[ 3 ] = 101;
  d_port = 7000;
  d_cancel = 0;
  memset( d_login, 0, 32 );
  memset( d_pass, 0, 32 );
}


cOptionsDialog::~cOptionsDialog() {}
////////////////////////////////////////////////////////////////////////////////

LRESULT cOptionsDialog::OnInitDialog( WPARAM wparam, LPARAM lparam ) {
  SendDlgItemMessage( d_hwnd, IDC_IP, IPM_SETADDRESS, 0, MAKEWORD( 0, 255 ) );
  SendDlgItemMessage( d_hwnd, IDC_IP, IPM_SETADDRESS, 1, MAKEWORD( 0, 255 ) );
  SendDlgItemMessage( d_hwnd, IDC_IP, IPM_SETADDRESS, 2, MAKEWORD( 0, 255 ) );
  SendDlgItemMessage( d_hwnd, IDC_IP, IPM_SETADDRESS, 3, MAKEWORD( 0, 255 ) );
  SendDlgItemMessage( d_hwnd, IDC_LOGIN, EM_SETLIMITTEXT, 32, 0 );
  SendDlgItemMessage( d_hwnd, IDC_PASS, EM_SETLIMITTEXT, 32, 0 );
  SendDlgItemMessage( d_hwnd, IDC_IP, IPM_SETADDRESS, 0, 
    MAKEIPADDRESS( d_ip[ 0 ], d_ip[ 1 ], d_ip[ 2 ], d_ip[ 3 ] ) );
  SetDlgItemInt( d_hwnd, IDC_PORT, d_port, 0 );

  return cDialogBox::OnInitDialog( wparam, lparam );
}


LRESULT cOptionsDialog::OnDestroy( WPARAM wparam, LPARAM lparam ) {
  return cDialogBox::OnDestroy( wparam, lparam );
}


LRESULT cOptionsDialog::OnCommand( WPARAM wparam, LPARAM lparam ) {
  switch( LOWORD( wparam ) ) {
    case ID_CONNECT:  OnConnect();  break;
    case IDCANCEL:  OnCancel();  break;
      break;
    default: break;
  }

  return cDialogBox::OnCommand( wparam, lparam );
}


LRESULT cOptionsDialog::OnClose( WPARAM wparam, LPARAM lparam  ) {
  OnCancel();
  return 1;
}


void cOptionsDialog::OnConnect() {
  DWORD IP;

  GetDlgItemText( d_hwnd, IDC_LOGIN, d_login, 32 );
  GetDlgItemText( d_hwnd, IDC_PASS, d_pass, 32 );
  d_port = GetDlgItemInt( d_hwnd, IDC_PORT, NULL, 0 );
  SendDlgItemMessage( d_hwnd, IDC_IP, IPM_GETADDRESS, 0, (LPARAM)&IP );
  d_ip[ 0 ] = FIRST_IPADDRESS( IP );
  d_ip[ 1 ] = SECOND_IPADDRESS( IP );
  d_ip[ 2 ] = THIRD_IPADDRESS( IP );
  d_ip[ 3 ] = FOURTH_IPADDRESS( IP );

  if( !strlen( d_login ) ) {
    MessageBox( NULL, "Name field cannot be left blank.", "Caution!", MB_APPLMODAL );
    return;
  }
  if( !d_port ) {
    MessageBox( NULL, "Port 0 is not allowed.", "Caution!", MB_APPLMODAL );
    return;
  }

  Destroy( 0 );
}


void cOptionsDialog::OnCancel() {
  if( IDYES == MessageBox( NULL, "Are you sure you want to quit?", "Network Client", MB_APPLMODAL | MB_YESNO ) ) {
    d_cancel = 1;
    Destroy( 1 );
  }
}

