#if !defined( __CNETWORKCLIENT_H )
#define __CNETWORKCLIENT_H
////////////////////////////////////////////////////////////////////////////////
#if !defined( __CCOMMCLIENTTHREAD_H )
#include "cCommClientThread.h"
#endif
#if !defined( __CWINDOW_H )
#include "cWindow.h"
#endif
#if !defined( __COPTIONSDIALOG_H )
#include "cOptionsDialog.h"
#endif
#if !defined( __CPATCH_H )
#include "cPatch.h"
#endif
#if !defined( __CD2D_H )
#include "cD2D.h"
#endif
#if !defined( __CDINPUT_H )
#include "cDInput.h"
#endif
#if !defined( __CCONSOLE_H )
#include "cConsole.h"
#endif
////////////////////////////////////////////////////////////////////////////////

class cNetworkClient : public cWindow {
protected:
  cOptionsDialog          d_options;
  cCommClientThread       d_clientThread;
  cDInput                 d_dinput;
  cD2D                    d_D2D;
  cLog                    d_log;
  cConsole                d_console;
  int                     d_isActive, d_isReady;

  DWORD                   d_lastTime;

  cPatch                  d_patches[ 4 ];
  int                     d_numPatches;

  int                     Update();

  // overidden methods
  virtual LRESULT         OnActivate( WPARAM wparam, LPARAM lparam );
  virtual LRESULT         OnMove( WPARAM wparam, LPARAM lparam );
  virtual LRESULT         OnSize( WPARAM wparam, LPARAM lparam );
  virtual LRESULT         OnTimer( WPARAM wparam, LPARAM lparam );
  virtual LRESULT         OnCommand( WPARAM wparam, LPARAM lparam );
  virtual LRESULT         OnOther( unsigned int msg, WPARAM wparam, LPARAM lparam );

  LRESULT                 OnGetHost( WPARAM wparam, LPARAM lparam );
  LRESULT                 OnAsync( WPARAM wparam, LPARAM lparam );

public:
  cNetworkClient();
  virtual ~cNetworkClient();

  int                     Startup( HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpCmdLine, int nCmdShow );
  void                    Shutdown();  // although it could probably be protected.

  int                     MainLoop();
};


#endif

