#if !defined( __CCOMMCLIENTTHREAD_H )
#define __CCOMMCLIENTTHREAD_H
////////////////////////////////////////////////////////////////////////////////
#if !defined( __CCOMM_H )
#include "cComm.h"
#endif
#if !defined( __CPLAYER_H )
#include "cPlayer.h"
#endif
#if !defined( __CMISSILE_H )
#include "cMissile.h"
#endif
#if !defined( __CMSG_H )
#include "cMsg.h"
#endif
#if !defined( __CLOG_H )
#include "cLog.h"
#endif
////////////////////////////////////////////////////////////////////////////////
#define NC_VERSIONMAJOR         0
#define NC_VERSIONMINOR         1

#define LAG_RECORDLENGTH        100

#define SNAPSHOTS_PER_SECOND    20
#define TIME_PER_SNAPSHOT       ( 1000 / SNAPSHOTS_PER_SECOND )
////////////////////////////////////////////////////////////////////////////////

class cCommClientThread : public cComm {
protected:
  cLog                    *d_pLog;   
  DWORD                   d_startTime,
                          d_firstPacketReceived,
                          d_lastPacketReceived,
                          d_lastPacketSent;
  int                     d_maxClients,
                          d_numClients,  // currently connected
                          d_updateReadDelay,
                          d_updateSendDelay,
                          d_pushLatency,
                          d_lagRecord[ LAG_RECORDLENGTH ];
  tcLinkedList<cPlayer>   d_clients;
  tcLinkedList<cVehicle>  d_vehicles;
  tcLinkedList<cMissile>  d_missiles;
  char                    d_name[ 32 ],
                          d_pass[ 32 ];

  virtual long            DetermineSize( int type );

  int                     SendMoveNotice();
  int                     SendKeepAlive();

  void                    ParseQueuedMessages();

  int                     ParseCollideNotice( void *pBuffer );
  int                     ParseSpawnNotice( void *pBuffer );
  int                     ParseSnapshot( void *pBuffer );
  int                     ParseMoveNotice( void *pBuffer );

  int                     ParseConnectNotice( void *pBuffer );
  int                     ParseLoginReply( void *pBuffer );

public:
  cCommClientThread();
  virtual ~cCommClientThread();

  // Intializing
  int                     Startup( HINSTANCE hInst, HINSTANCE hPrev, HWND hwnd, cLog *pLog );
  int                     Shutdown();

  int                     Update( DWORD deltaTime );

  // Overidden methods
  virtual int             OnGetHost( WPARAM wparam, LPARAM lparam );
  virtual LRESULT         OnAsync( WPARAM wparam, LPARAM lparam );

  tcLinkedList<cPlayer>   *GetClients() {  return &d_clients;  }
  tcLinkedList<cMissile>  *GetMissiles() {  return &d_missiles;  }
  tcLinkedList<cVehicle>  *GetVehicles() {  return &d_vehicles;  }
  int                     *GetLagRecord() {  return d_lagRecord;  }
  inline int              GetPushLatency() {  return d_pushLatency;  }

  void SetName( char *pName ) {
    if( pName ) strcpy( d_name, pName );
  }


  void SetPass( char *pPass ) {
    if( pPass ) strcpy( d_pass, pPass );
  }
};


#endif

