#if !defined( __CVECHICLE_H )
#define __CVEHICLE_H
////////////////////////////////////////////////////////////////////////////////
#if !defined( __CVECTOR3_H )
#include "cVector3.h"
#endif
#if !defined( __CPOLY_H )
#include "cPoly.h"
#endif
#if !defined( __TCLINKEDLIST_H )
#include "tcLinkedList.h"
#endif
#if defined( _CLIENT ) && !defined( __CD2D_H )
#include "../NetworkClient/cD2D.h"
#endif
////////////////////////////////////////////////////////////////////////////////
// Bad C++ - find a better place to define this?
#define PI            3.14159265358979323846264338327950
#define TWOPI         ( PI * 2.0 )
#define ONERAD        ( PI / 180.0 )
////////////////////////////////////////////////////////////////////////////////

// Can easily be derived into various types of vehicles...
class cVehicle {
protected:
  tcLinkedList<cPoly> *d_pPolygons;
  cVector3            d_maxAccel;
  float               d_maxTurnVel,
                      d_radarRange,
                      d_fireRange;

public:
  cVehicle();
  virtual ~cVehicle();

  int                 LoadModel( char *pFilename );
  void                UnloadModel();

#if defined( _CLIENT )
  void                TransformProject( cD2D *pD2D, cMatrix4 *pMat );
  void                Render( cD2D *pD2D );
#endif

  inline cVector3     GetMaxAccel() {  return d_maxAccel;  }
  inline float        GetMaxTurnVel() {  return d_maxTurnVel;  }
};


#endif

