#if !defined( _CVEHICLE_H )
#include "cVehicle.h"
#endif
////////////////////////////////////////////////////////////////////////////////

cVehicle::cVehicle() {
  d_pPolygons = NULL;
  d_maxTurnVel = 0;
}


cVehicle::~cVehicle() {
  UnloadModel();
}
////////////////////////////////////////////////////////////////////////////////

// Since this is the base class it loads a simple 3 triangle model, hardcoded.
int cVehicle::LoadModel( char *pFilename ) {
  tcLinkedList<cPoly> *pPoly;
  int                 i, j;

  for( i = 0; i < 3; i++ ) {
    pPoly = new tcLinkedList<cPoly>;
    if( !pPoly ) break;

    // link the newly allocated poly
    if( !d_pPolygons ) {
      d_pPolygons = pPoly;
    } else d_pPolygons->Link( pPoly );

    // allocate points to the polygon
    for( j = 0; j < 3; j++ ) {
      pPoly->d_pPoints[ j ] = new cVector3;
      if( !pPoly->d_pPoints[ j ] ) break;
    }
    if( j != 3 ) break;

    // set up some poly properties
    pPoly->SetColor( cVector3( 255, 255, 255 ) );
  }
  // mem alloc error
  if( i != 3 ) {
    UnloadModel();
    return 1;
  }

  // Set some more poly properties
  pPoly = d_pPolygons;
  pPoly->d_pPoints[ 0 ]->Position(  20,   0,   0 );
  pPoly->d_pPoints[ 1 ]->Position(   0,   0, -10 );
  pPoly->d_pPoints[ 2 ]->Position( -10, -10,   0 );

  pPoly = pPoly->GetNext();
  pPoly->d_pPoints[ 0 ]->Position(  20,   0,   0 );
  pPoly->d_pPoints[ 1 ]->Position( -10,  10,   0 );
  pPoly->d_pPoints[ 2 ]->Position(   0,   0, -10 );

  pPoly = pPoly->GetNext();
  pPoly->d_pPoints[ 0 ]->Position( -10, -10,   0 );
  pPoly->d_pPoints[ 1 ]->Position(   0,   0, -10 );
  pPoly->d_pPoints[ 2 ]->Position( -10,  10,   0 );

  // Set up some vehicle properties
  d_maxAccel.Position( 25.0f, 0, 0 );
  d_maxTurnVel = 270;  // per second
  d_radarRange = 0;
  d_fireRange = 0;

  return 0;
}


void cVehicle::UnloadModel() {
  tcLinkedList<cPoly> *pPoly, *pNextPoly;
  int                 i;

  // Delete the allocated polygons.
  for( pPoly = d_pPolygons; pPoly; pPoly = pNextPoly ) {
    pNextPoly = pPoly->GetNext();

    for( i = 0; i < pPoly->GetNumPoints(); i++ ) {
      if( !pPoly->d_pPoints[ i ] ) break;
      delete pPoly->d_pPoints[ i ];
    }
    delete pPoly;
  }

  // Set the pointer back to null.
  d_pPolygons = NULL;
}


#if defined( _CLIENT )
void cVehicle::TransformProject( cD2D *pD2D, cMatrix4 *pMat ) {
  tcLinkedListItterator<cPoly> itter;

  if( !pD2D || !pMat ) return;

  for( itter = d_pPolygons; itter(); ++itter ) {
    itter()->TransformProject( pD2D, pMat );
  }
}


void cVehicle::Render( cD2D *pD2D ) {
  tcLinkedListItterator<cPoly>  itter;
  int                           i, j;

  if( !pD2D ) return;


  // Render the polygons
  for( itter = d_pPolygons; itter(); ++itter ) {
    if( itter()->GetClipped() ) continue;

    for( i = 0; i < itter()->GetNumPoints(); i++ ) {
      j = ( i + 1 ) % itter()->GetNumPoints();
      pD2D->DrawLine( (long)itter()->d_screenPoints[ i ].d_x, (long)itter()->d_screenPoints[ i ].d_y,
                      (long)itter()->d_screenPoints[ j ].d_x, (long)itter()->d_screenPoints[ j ].d_y,
                      (int)itter()->GetColor().d_r, (int)itter()->GetColor().d_g,
                      (int)itter()->GetColor().d_b, (int)0xff );
    }
  }

  // Render the bounding box?    
}
#endif

