#ifndef __CVECTOR4_H
#define __CVECTOR4_H
////////////////////////////////////////////////////////////////////////////////
#include <math.h>
////////////////////////////////////////////////////////////////////////////////
class cVector3;

class cVector4 {
public:
  float  d_x, d_y, d_z, d_w;

  ////////////////////////////////////////////////////////////////////////////////
  // constructors & destructors
  ////////////////////////////////////////////////////////////////////////////////

  cVector4() {
    d_x = 0.0f;
    d_y = 0.0f;
    d_z = 0.0f;
    d_w = 1.0f;
  }


  cVector4( float x, float y, float z, float w ) {
    d_x = x;
    d_y = y;
    d_z = z;
    d_w = w;
  }


  cVector4( float v[ 4 ] ) {
    d_x = v[ 0 ];
    d_y = v[ 1 ];
    d_z = v[ 2 ];
    d_w = v[ 3 ];
  }


  ~cVector4() {}
  ////////////////////////////////////////////////////////////////////////////////
  // methods
  ////////////////////////////////////////////////////////////////////////////////

  // all those operators that appear in cVector3 may have to be duplicated here...yawn...
  inline cVector4 &operator = ( const cVector4 &vec ) {
    d_x = vec.d_x;
    d_y = vec.d_y;
    d_z = vec.d_z;
    d_w = vec.d_w;

    return *this;
  }

  inline cVector4 operator * ( const float scale ) {
    return cVector4( d_x * scale, d_y * scale, d_z * scale, d_w * scale );
  }

  inline cVector4 operator / ( const float scale ) {
    float div = 1.0f / scale;

    return cVector4( d_x * div, d_y * div, d_z * div, d_w * div );
  }

  inline cVector4 operator + ( const cVector4 &vec ) {
    return cVector4( d_x + vec.d_x, d_y + vec.d_y, d_z + vec.d_y, d_w + vec.d_w );
  }

  inline cVector4 operator - ( const cVector4 &vec ) {
    return cVector4( d_x - vec.d_x, d_y - vec.d_y, d_z - vec.d_y, d_w - vec.d_w );
  }
  
  inline float operator | ( const cVector4 &vec ) {
    return d_x * vec.d_x + d_y * vec.d_y + d_z * vec.d_z + d_w * vec.d_w;
  }

  inline int operator == ( const cVector4 &vec ) {
    if( fabs( d_x - vec.d_x ) < 0.01f && fabs( d_y - vec.d_y ) < 0.01f &&
      fabs( d_z - vec.d_z ) < 0.01f && fabs( d_w - vec.d_w ) < 0.01f ) return 1;
    return 0;
  }

  inline int operator != ( const cVector4 &vec ) {
    if( fabs( d_x - vec.d_x ) < 0.01f && fabs( d_y - vec.d_y ) < 0.01f &&
      fabs( d_z - vec.d_z ) < 0.01f && fabs( d_w - vec.d_w ) < 0.01f ) return 0;
    return 1;
  }

  inline cVector4 &operator *= ( const float scale ) {
    d_x *= scale;
    d_y *= scale;
    d_z *= scale;
    d_w *= scale;
    return *this;
  }

  inline cVector4 &operator /= ( const float scale ) {
    float div;
    
    if( !scale ) return *this;
    div = 1.0f / scale;
    d_x *= div;
    d_y *= div;
    d_z *= div;
    d_w *= div;
    return *this;
  }
  
  inline cVector4 &operator += ( const cVector4 &vec ) {
    d_x += vec.d_x;
    d_y += vec.d_y;
    d_z += vec.d_z;
    d_w += vec.d_w;
    return *this;
  }
  
  inline cVector4 &operator -= ( const cVector4 &vec ) {
    d_x -= vec.d_x;
    d_y -= vec.d_y;
    d_z -= vec.d_z;
    d_w -= vec.d_w;
    return *this;
  }

  // this starts to make things ugly...
  cVector4 &operator = ( const cVector3 &vec );
};


#endif

