#if !defined( __CPOLY_H )
#define __CPOLY_H
////////////////////////////////////////////////////////////////////////////////
#if !defined( __CVECTOR3_H )
#include "cVector3.h"
#endif
#if !defined( __CMATRIX4_H )
#include "cMatrix4.h"
#endif
#if defined( _CLIENT ) && !defined( __CD2D_H )
#include "cD2D.h"
#endif
////////////////////////////////////////////////////////////////////////////////

class cPoly {
protected:
  cVector3    d_normal,
              d_color;
  bool        d_clipped;
  int         d_style,
              d_numPoints;

public:
  cVector3    *d_pPoints[ 3 ],
              d_screenPoints[ 3 ];


  cPoly();
  ~cPoly();

  void        SetColor( cVector3 color ) {  d_color = color;  }
  cVector3    GetColor() {  return d_color;  }
  cVector3    BuildNormal();

#if defined( _CLIENT )
  void        TransformProject( cD2D *pD2D, cMatrix4 *pMat );
#endif

  bool        GetClipped() {  return d_clipped;  }
  int         GetNumPoints() {  return d_numPoints;  }
};


#endif

