#if !defined( __CPOLY_H )
#include "cPoly.h"
#endif
////////////////////////////////////////////////////////////////////////////////

cPoly::cPoly() {
  d_clipped = 0;
  d_style = 0;
  d_numPoints = 3;
}


cPoly::~cPoly() {}
////////////////////////////////////////////////////////////////////////////////

cVector3 cPoly::BuildNormal() {
  cVector3 a, b;
  int      i;

  if( d_numPoints < 3 ) return cVector3();

  b = *d_pPoints[ 1 ] - *d_pPoints[ 0 ];
  b.Normalize();
  for( i = 2; i < d_numPoints; i++ ) {
    a = *d_pPoints[ i ] - *d_pPoints[ 0 ];
    a.Normalize();
    if( a != b && a != ( b * -1 ) ) break;
  }
  d_normal = b ^ a;

  return d_normal;
}


#if defined( _CLIENT )
void cPoly::TransformProject( cD2D *pD2D, cMatrix4 *pMat ) {
  if( !pD2D || !pMat ) return;

  cVector3  aspectRatio, halfSize;
  int       i, width, height;

  width = pD2D->GetWidth();
  height = pD2D->GetHeight();
  if( !width || !height ) return;

  halfSize.d_x = (float)( width >> 1 );
  halfSize.d_y = (float)( height >> 1 );
  aspectRatio.d_x = pD2D->GetAspectX() * halfSize.d_x;
  aspectRatio.d_y = pD2D->GetAspectY() * halfSize.d_y;

  // Poly screen coordinates
  for( i = 0; i < d_numPoints; i++ ) {
    d_screenPoints[ i ] = *d_pPoints[ i ] * *pMat;

    if( d_screenPoints[ i ].d_z <= 0 ) break;
    d_screenPoints[ i ].d_x = ( aspectRatio.d_x * d_screenPoints[ i ].d_x / d_screenPoints[ i ].d_z ) + halfSize.d_x;
    if( d_screenPoints[ i ].d_x >= width || d_screenPoints[ i ].d_x < 0 ) break;
    d_screenPoints[ i ].d_y = ( aspectRatio.d_y * d_screenPoints[ i ].d_y / d_screenPoints[ i ].d_z ) + halfSize.d_y;
    if( d_screenPoints[ i ].d_y >= height || d_screenPoints[ i ].d_y < 0 ) break;
  }
  if( i != d_numPoints ) d_clipped = 1;
  else d_clipped = 0;
}
#endif


