#if !defined( __CPLAYER_H )
#define __CPLAYER_H
////////////////////////////////////////////////////////////////////////////////
#if !defined( __CVECTOR3_H )
#include "cVector3.h"
#endif
#if !defined( __CCLIENT_H )
#include "cClient.h"
#endif
#if !defined( __CPOLY_H )
#include "cPoly.h"
#endif
#if !defined( __CVEHICLE_H )
#include "cVehicle.h"
#endif
#if !defined( __CSTATE_H )
#include "State.h"
#endif
#if !defined( __CMSG_H )
#include "cMsg.h"
#endif
////////////////////////////////////////////////////////////////////////////////

class cPlayer : public cClient {
protected:
  cMatrix4          d_location;  // position contained in location.
  cVector3          d_velocity;  // unrelated to orientation.
  float             d_angle;
  DWORD             d_packetId,  // id of the last snapshot received
                    d_idleTime,  // since last message received
                    d_stateTime;  // for various state animations
  int               d_state,
                    d_motionFlags,  // helps client determine event occurrence
                    d_oldMotionFlags;  // helps reduce network overhead
  int               d_fireState;  // eFireState value.  Could be moved to a cWeapon class...
  int               d_security;  // what client is allowed to do NOT USED
  cVehicle          *d_pVehicle;  // what kind of vehicle is being used?

public:
  cPlayer();
  virtual ~cPlayer();

  // move & update
  void              Update( DWORD deltaTime );

#if defined( _CLIENT )
  void              Render( cD2D *pD2D, cMatrix4 *pMat );
#endif

  cMatrix4          *GetLocation() {  return &d_location;  }
  void              SetLocation( cMatrix4 *location ) {  d_location = *location;  }
  cVector3          GetVelocity() {  return d_velocity;  }
  void              SetVelocity( cVector3 vel ) {  d_velocity = vel;  }
  DWORD             GetIdleTime() {  return d_idleTime;  }
  void              SetIdleTime( DWORD idleTime ) {  d_idleTime = idleTime;  }

  inline int        GetSecurity() {  return d_security;  }
  inline void       SetSecurity( int security ) {  d_security = security;  }
  inline cVehicle   *GetVehicle() {  return d_pVehicle;  }
  inline void       SetVehicle( cVehicle *pVehicle ) {  d_pVehicle = pVehicle;  }
  inline void       SetPacketId( DWORD packetId ) {  d_packetId = packetId;  }
  inline DWORD      GetPacketId() {  return d_packetId;  }
  inline void       SetMotionFlags( int motionFlags ) {  d_motionFlags = motionFlags;  }
  inline int        GetMotionFlags() {  return d_motionFlags;  }
  inline void       SetOldMotionFlags( int motionFlags ) {  d_oldMotionFlags = motionFlags;  }
  inline int        GetOldMotionFlags() {  return d_oldMotionFlags;  }

  inline int        GetFireState() {  return d_fireState;  }

  inline float      GetAngle() {  return d_angle;  }
  inline void       SetAngle( float angle ) {
    cVector3 pos;

    if( angle == d_angle ) return;

    pos.Position( d_location.a30, d_location.a31, d_location.a32 );
    d_location.MakeIdentity();
    d_location.RotateAroundLocalAxis( 2, d_angle );
    d_angle = angle;
    d_location.a30 = pos.d_x;
    d_location.a31 = pos.d_y;
    d_location.a32 = pos.d_z;
  }

  inline int        GetState() {  return d_state;  }
  inline void       SetState( int state, int stateTime = 0 ) {
    d_state = state;
    d_stateTime = stateTime;
  }
};


#endif

