#if !defined( __CPLAYER_H )
#include "cPlayer.h"
#endif
////////////////////////////////////////////////////////////////////////////////

cPlayer::cPlayer() : cClient() {
  d_security = 0;
  d_idleTime = 0;
  d_packetId = 0;
  d_motionFlags = MOTION_NONE;
  d_oldMotionFlags = MOTION_NONE;
  d_angle = 0.0f;
  d_pVehicle = NULL;
  d_fireState = FIRESTATE_OFF;
  d_state = STATE_DEAD;
  d_stateTime = 0;
}


cPlayer::~cPlayer() {}
////////////////////////////////////////////////////////////////////////////////

void cPlayer::Update( DWORD deltaTime ) {
  cVector3  pos, accel;
  float     turnVel;

  if( d_state == STATE_DEAD || d_idleTime > 1000 ) return;

  if( d_pVehicle ) {
    turnVel = d_pVehicle->GetMaxTurnVel() * (float)ONERAD;
  } else turnVel = (float)ONERAD;
  turnVel *= (float)deltaTime / 1000.0f;

  if( d_motionFlags & MOTION_TURNLEFT ) d_angle += turnVel;
  if( d_motionFlags & MOTION_TURNRIGHT ) d_angle -= turnVel;
  if( d_angle < 0.0f ) d_angle += (float)TWOPI;
  else if( d_angle >= TWOPI ) d_angle -= (float)TWOPI;

  if( d_motionFlags & MOTION_FIRESTART ) {
    if( d_fireState == FIRESTATE_START ) d_fireState = FIRESTATE_ON;
    else d_fireState = FIRESTATE_START;
  } else if( d_motionFlags & MOTION_FIREEND ) {
    if( d_fireState == FIRESTATE_END ) d_fireState = FIRESTATE_OFF;
    else d_fireState = FIRESTATE_END;
  }
  if( d_motionFlags & MOTION_MOVEMASK ) {
    if( d_pVehicle ) accel = d_pVehicle->GetMaxAccel();
    else accel = cVector3( 10.0f, 0.0f, 0.0f );

    if( d_motionFlags & MOTION_MOVEFORWARD ) {
      d_velocity.d_x = d_location.a00 * accel.d_x;
      d_velocity.d_y = d_location.a01 * accel.d_x;
      d_velocity.d_z = d_location.a02 * accel.d_x;
    }
    if( d_motionFlags & MOTION_MOVEBACKWARD ) {
      d_velocity.d_x = d_location.a00 * -accel.d_x;
      d_velocity.d_y = d_location.a01 * -accel.d_x;
      d_velocity.d_z = d_location.a02 * -accel.d_x;
    }
  } else d_velocity.Position( 0, 0, 0 );

  // Now apply the rotation/translation
  pos.Position( d_location.a30, d_location.a31, d_location.a32 );

  // Bad C++ - another option would be to build a precomputed table of 256 angles, then
  // round angle off to the nearest whole number and just assign.  save a lot of work.
  if( d_motionFlags & MOTION_TURNMASK ) {
    d_location.MakeIdentity();
    d_location.RotateAroundLocalAxis( 2, d_angle );
  }
  pos += d_velocity * ( (float)deltaTime / 1000.0f );

  d_location.a30 = pos.d_x;
  d_location.a31 = pos.d_y;
  d_location.a32 = pos.d_z;

  // update player state
  d_stateTime += deltaTime;

  switch( d_state ) {
    case STATE_DEAD:  break;  // nothing happens while you're dead (duh.)
    case STATE_DYING:
      SetState( STATE_DEAD );  // if there was an animation there'd be a delay...
      break;
    case STATE_ALIVE:  break;  // we could do other animations here...
    case STATE_BIRTH:  // we'll set up the server so you can't be hurt while being born.
      if( d_stateTime > 3000 ) SetState( STATE_ALIVE );
      break;
  }

  d_idleTime += deltaTime;
}


#if defined( _CLIENT )
// Add in something for idle time > 100
void cPlayer::Render( cD2D *pD2D, cMatrix4 *pMat ) {
  if( !d_pVehicle || !pD2D || !pMat ) return;

  d_pVehicle->TransformProject( pD2D, pMat );
  d_pVehicle->Render( pD2D );
}
#endif

