#if !defined( __CMSQUEUE_H )
#define __CMSQUEUE_H
#define WINDOWS_LEAN_AND_MEAN
#include <windows.h>
////////////////////////////////////////////////////////////////////////////////

class cMsgQueue {
protected:
  void        *d_pBuffer;
  long        d_size,
              d_transmitted;
  bool        d_isArray;

public:
  cMsgQueue() {
    d_pBuffer = NULL;
    d_transmitted = 0;
    d_size = 0;
    d_isArray = 0;
  }


  virtual ~cMsgQueue() {
    if( d_pBuffer ) {
      if( d_isArray ) delete [] d_pBuffer;
      else delete d_pBuffer;
    }
  }


  void SetBuffer( void *pBuffer, int size, bool isArray = 0 ) {
    if( !pBuffer ) return;
    d_pBuffer = pBuffer;
    d_size = size;
    d_transmitted = 0;
    d_isArray = isArray;
  }


  inline void *GetBuffer() { return d_pBuffer; }
  inline long GetSize() { return d_size; }
  inline long GetTransmitted() { return d_transmitted; }
  inline void AddTransmitted( long amnt ) { d_transmitted += amnt; }
};


#endif

