#if !defined( __CMSG_H )
#define __CMSG_H
////////////////////////////////////////////////////////////////////////////////
#if !defined( __CVECTOR3_H )
#include "cVector3.h"
#endif
////////////////////////////////////////////////////////////////////////////////

enum eMsgType {
  MSG_DEFAULT       = 0,
  MSG_LOGINREQUEST  = 1,  // client's first message to server
  MSG_LOGINREPLY    = 2,  // server's response
  MSG_CONNECTNOTICE = 3,  // player's connect status has changed
  MSG_SNAPSHOT      = 4,
  MSG_MOVENOTICE    = 5,  // player has moved
  MSG_SPAWNNOTICE   = 6,
  MSG_DEATHNOTICE   = 7,
  MSG_COLLIDENOTICE = 8,
  MSG_KEEPALIVE     = 9,
};


enum eLoginReply {
  LOGIN_OK          = 0,
  LOGIN_BADFULL     = 1,  // max clients
  LOGIN_BADOUTDATED = 2,  // client not compatible with server
  LOGIN_BADPASS     = 3,  // wrong password
  LOGIN_BADNAME     = 4,  // name being used already
  LOGIN_BADUNKNOWN  = 5,  // ?
};


enum eMotionFlags {
  MOTION_NONE         =  0,
  MOTION_TURNLEFT     =  1,
  MOTION_TURNRIGHT    =  2,
  MOTION_TURNMASK     =  3,
  MOTION_MOVEFORWARD  =  4,
  MOTION_MOVEBACKWARD =  8,
  MOTION_MOVEMASK     = 12,
  MOTION_FIRESTART    = 16,
  MOTION_FIREEND      = 32,
  MOTION_FIREMASK     = 48,
};


enum eObjectType {
  OBJTYPE_UNDEFINED = 0,
  OBJTYPE_PLAYER    = 1,
  OBJTYPE_MISSILE   = 2,
  OBJTYPE_PLANET    = 3,  // not used
  OBJTYPE_SUN       = 4,  // not used
  OBJTYPE_BLACKHOLE = 5,  // not used
};


// Request sent to server
struct cMsgLoginRequest {
  int             d_type;
  short int       d_version[ 2 ];  // major/minor version
  char            d_name[ 32 ],
                  d_pass[ 32 ];
};


// object identification
struct cObjectId {
  eObjectType     d_type;
  int             d_id;
};


// Reply from server.
struct cMsgLoginReply {
  int             d_type;
  eLoginReply     d_success;
  char            d_maxClients;
  DWORD           d_lastPacketId;
  int             d_id;
};


// Tell other clients of new login.
// New clients receive [numClients] of these
struct cMsgConnectNotice {
  int             d_type;
  char            d_name[ 32 ],
                  d_connState;  // STATE_CONNECTING, STATE_CONNECTED or STATE_DISCONNECTING
  cObjectId       d_obj;
  cVector3        d_pos;  // if connected already
  float           d_angle;  // if connected already
  int             d_motionFlags,  // if connected already
                  d_state;  // if connected already
};


// indicates how many cMsgMoveNotice follow
struct cMsgSnapshot {
  int             d_type,
                  d_numClients;
  DWORD           d_packetId,
                  d_lastPacketReceived;
};


struct cMsgMoveNotice {
  int             d_type;
  cObjectId       d_obj;
  cVector3        d_pos;
  float           d_angle;  // current facing
  int             d_motionFlags;  // turning, firing, moving?
  DWORD           d_packetId;
};


struct cMsgSpawnNotice {
  int             d_type;
  cObjectId       d_obj,
                  d_creator;
  cVector3        d_pos;
  float           d_angle;
};


struct cMsgDeathNotice {
  int             d_type;
  cObjectId       d_victim,
                  d_killer;
};


struct cMsgCollideNotice {
  int             d_type;
  cObjectId       d_colliders[ 2 ];
};


struct cMsgKeepAlive {
  int             d_type;
  cObjectId       d_obj;
  DWORD           d_packetId;
};


#endif

