#if !defined( __CMISSILE_H )
#define __CMISSILE_H
////////////////////////////////////////////////////////////////////////////////
#define WINDOWS_LEAN_AND_MEAN
#include <windows.h>

#if !defined( __CVECTOR3_H )
#include "cVector3.h"
#endif
#if !defined( __CMATRIX4_H )
#include "cMatrix4.h"
#endif
#if !defined( __STATE_H )
#include "State.h"
#endif
#if defined( _CLIENT ) && !defined( __CD2D_H ) 
#include "cD2D.h"
#endif
////////////////////////////////////////////////////////////////////////////////

class cMissile {
protected:
  int               d_id,  // unique to all missiles
                    d_state,
                    d_creator;  // Which player fired this missile?
  cVector3          d_vel;
  cMatrix4          d_location;
  DWORD             d_stateTime;

public:
  cMissile();
  virtual ~cMissile();

  void              Update( DWORD deltaTime );
  void              Fire( cVector3 pos, float vel, float angle );

#if defined( _CLIENT )
  void              Render( cD2D *pD2D, cMatrix4 *pMat );
#endif

  cMatrix4          *GetLocation() {  return &d_location;  }
  void              SetLocation( cMatrix4 *location ) {  d_location = *location;  }
  inline int        GetCreator() {  return d_creator;  }
  inline void       SetCreator( int creator ) {  d_creator = creator;  }
  inline int        GetId() {  return d_id;  }
  inline void       SetId( int id ) {  d_id = id;  }

  inline cVector3   GetVelocity() {  return d_vel;  }

  inline int GetState() {  return d_state;  }
  inline void SetState( int state ) {
    d_state = state;
    d_stateTime = 0;
  }
};


#endif

