#if !defined( __CMISSILE_H )
#include "cMissile.h"
#endif
////////////////////////////////////////////////////////////////////////////////

cMissile::cMissile() {
  d_creator = 0;
  d_state = STATE_DEAD;
  d_stateTime = 0;
  d_id = 0;
  d_location.MakeIdentity();
}


cMissile::~cMissile() {
}
////////////////////////////////////////////////////////////////////////////////

void cMissile::Update( DWORD deltaTime ) {
  cVector3 dvel;

  // Of course, vel should be recalculated every frame
  // based on the gravity of the nearby planets...
  dvel = d_vel * ( (float)deltaTime / 1000.0f );

  d_location.a30 += dvel.d_x;
  d_location.a31 += dvel.d_y;
  d_location.a32 += dvel.d_z;

  d_stateTime += deltaTime;

  switch( d_state ) {
    case STATE_DEAD:  break;
    case STATE_DYING:
      SetState( STATE_DEAD );
      break;
    case STATE_ALIVE:
      // kill this missile after being alive for 1 minute, just to be safe.
      if( d_stateTime > 60000 ) SetState( STATE_DYING );
      break;
    case STATE_BIRTH:
      SetState( STATE_ALIVE );
      break;
  }
}


void cMissile::Fire( cVector3 pos, float vel, float angle ) {
  SetState( STATE_BIRTH );

  d_location.MakeIdentity();
  if( angle ) d_location.RotateAroundLocalAxis( 2, angle );

  d_location.a30 = pos.d_x;
  d_location.a31 = pos.d_y;
  d_location.a32 = pos.d_z;

  d_vel = cVector3( d_location.a00, d_location.a01, d_location.a02 ) * vel;
}


#if defined( _CLIENT )
void cMissile::Render( cD2D *pD2D, cMatrix4 *pMat ) {
  if( !pD2D || !pMat ) return;

  cVector3  aspectRatio, halfSize, center;
  int       width, height;

  width = pD2D->GetWidth();
  height = pD2D->GetHeight();
  if( !width || !height ) return;

  halfSize.d_x = (float)( width >> 1 );
  halfSize.d_y = (float)( height >> 1 );
  aspectRatio.d_x = pD2D->GetAspectX() * halfSize.d_x;
  aspectRatio.d_y = pD2D->GetAspectY() * halfSize.d_y;

  // Relative to itself, the middle is 0,0,0. Remember that
  // pMat = missileMatrix * cameraMatrix.
  // (which takes care of local->world and world->camera
  center = cVector3( 0, 0, 0 ) * *pMat;

  // This part does camera->view
  if( center.d_z <= 0 ) return;
  center.d_x = ( aspectRatio.d_x * center.d_x / center.d_z ) + halfSize.d_x;
  if( center.d_x >= width - 2.5 || center.d_x < 2.5 ) return;
  center.d_y = ( aspectRatio.d_y * center.d_y / center.d_z ) + halfSize.d_y;
  if( center.d_y >= height - 2.5 || center.d_y < 2.5 ) return;

  pD2D->DrawLine( (long)center.d_x - 5, (long)center.d_y    , (long)center.d_x + 5, (long)center.d_y    , 255, 255, 255, 255 );
  pD2D->DrawLine( (long)center.d_x    , (long)center.d_y - 5, (long)center.d_x    , (long)center.d_y + 5, 255, 255, 255, 255 );
  pD2D->DrawLine( (long)center.d_x - 4, (long)center.d_y - 4, (long)center.d_x + 4, (long)center.d_y + 4, 255, 255, 255, 255 );
  pD2D->DrawLine( (long)center.d_x + 4, (long)center.d_y - 4, (long)center.d_x - 4, (long)center.d_y + 4, 255, 255, 255, 255 );
}
#endif