/* Project: <misc>
 * File   : cDialogBox.h
 * Created: 19/10/98 Dan Royer
 * Nothing can be done to cDialog until WM_INITDIALOG, anything before that should be
 * taken care of automatically by the compiled application
 */
////////////////////////////////////////////////////////////////////////////////
#ifndef __CDIALOGBOX_H
#define __CDIALOGBOX_H
////////////////////////////////////////////////////////////////////////////////
#define WIN32_LEAN_AND_MEAN
#include <windows.h>  // HINSTANCE, HWND, LRESULT, CALLBACK
////////////////////////////////////////////////////////////////////////////////
class cDialogBox {
protected:
  HWND              d_hwnd,
                    d_hwndParent;
  HINSTANCE         d_hInstance;
  int               d_templateId,
                    d_active;

  virtual LRESULT   OnInitDialog( WPARAM wparam, LPARAM lparam );  // WM_INITDIALOG
  virtual LRESULT   OnSetCursor( WPARAM wparam, LPARAM lparam );  // WM_SETCURSOR
  virtual LRESULT   OnActivate( WPARAM wparam, LPARAM lparam );  // WM_ACTIVATE
  virtual LRESULT   OnSize( WPARAM wparam, LPARAM lparam );  // WM_SIZE
  virtual LRESULT   OnMove( WPARAM wparam, LPARAM lparam );  // WM_MOVE
  virtual LRESULT   OnPaint( WPARAM wparam, LPARAM lparam );  // WM_PAINT
  virtual LRESULT   OnEraseBkgnd( WPARAM wparam, LPARAM lparam );  // WM_ERASEBKGND
  virtual LRESULT   OnKeyDown( WPARAM wparam, LPARAM lparam );  // WM_KEYDOWN
  virtual LRESULT   OnKeyUp( WPARAM wparam, LPARAM lparam );  // WM_KEYUP
  virtual LRESULT   OnTimer( WPARAM wparam, LPARAM lparam );  // WM_TIMER
  virtual LRESULT   OnCommand( WPARAM wparam, LPARAM lparam );  // WM_COMMAND
  virtual LRESULT   OnNotify( WPARAM wparam, LPARAM lparam );  // WM_NOTIFY
  virtual LRESULT   OnClose( WPARAM wparam, LPARAM lparam );  // WM_CLOSE
  virtual LRESULT   OnDestroy( WPARAM wparam, LPARAM lparam );  // WM_DESTROY
  virtual LRESULT   OnOther( UINT msg, WPARAM wparam, LPARAM lparam );  // anything else

  inline void       EnableWindowItem( int itemId, int newState );

public:
  cDialogBox();
  virtual ~cDialogBox();

  int               Init( HINSTANCE hInstance, int templateId );
  int               Create( HWND hwndParent = NULL );
  BOOL              Show( int cmdShow );
  void              Update();
  void              Destroy( int returnCode );
  HWND              GetHandle();

  int               GetIsActive() { return d_active; }

  // Provided only to be overridden.
  virtual void      UpdateData() {}

  LRESULT CALLBACK  DlgProc( HWND hwnd, UINT MSG, WPARAM wparam, LPARAM lparam );
};
////////////////////////////////////////////////////////////////////////////////
#endif
////////////////////////////////////////////////////////////////////////////////
// EOF /////////////////////////////////////////////////////////////////////////

