#ifndef __CCONSOLE_H
#define __CCONSOLE_H
////////////////////////////////////////////////////////////////////////////////
#if !defined( __CD2D_H )
#include "cD2D.h"
#endif
#if !defined( __CLOG_H )
#include "cLog.h"
#endif
////////////////////////////////////////////////////////////////////////////////

class cConsole {
protected:
  unsigned int    d_state,  // active or not?
                  d_width, d_height,  // dimension in pixels
                  d_offx, d_offy,  // offset from top left corner
                  d_lines, d_columns;  // dimension in characters
  cD2D            *d_pD2D;
  cLog            *d_pLog;

public:
  cConsole();
  ~cConsole();

  int             Init( cD2D *pD2D, cLog *pLog );
  int             Resize( RECT *pos );
  void            Render( char *pText );

  inline void     SetState( int state ) { d_state = state; }
  inline int      GetState() { return d_state; }
};


#endif

