/* Project: Windows API socket server/client
 * File   : cComm.h
 * Created: 27/07/98 Dan Royer
 * Note   : Creates the socket, header holds values from all over program
 */
////////////////////////////////////////////////////////////////////////////////
#if !defined( __CCOMM_H )
#define __CCOMM_H
////////////////////////////////////////////////////////////////////////////////
#include <winsock2.h>
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#if !defined( __CCLIENT_H )
#include "cClient.h"
#endif
////////////////////////////////////////////////////////////////////////////////
#define WINSOCK_VERSIONMAJOR    2
#define WINSOCK_VERSIONMINOR    0

// Default values
#define DEFAULT_SERVERNAME      "127.0.0.1"
#define DEFAULT_SERVERPORT      7000
#define DEFAULT_SESSIONNAME     "default session"

#define IDLE_TIMEOUT            5000  // milliseconds

// Protocols - If UDP is not wanted then TCP will be used
//#define UDP_PROTOCOL

// Messages for asynchronous notification                    
#define SM_GETHOST	            ( WM_USER + 1 )
#define SM_ASYNC	              ( WM_USER + 2 )

// Client or Server mode?
enum eCommMode {
  MODE_CLIENT = 0,
  MODE_SERVER = 1,
};

// Connection state
enum eConnectState {
  STATE_DISCONNECTED  = 0,
  STATE_CONNECTING    = 1,
  STATE_CONNECTED     = 2,
  STATE_DISCONNECTING = 3,
};

////////////////////////////////////////////////////////////////////////////////

struct cMsg {
  int                   d_type;
};


class cComm {
protected:
  HWND                  d_hwnd;  // window we are sending messages to
  WSADATA               d_winsockData;
  unsigned short        d_winsockVersion;
  SOCKET                d_socket;  // differs from clients' sockets
  SOCKADDR_IN           d_address;
  HANDLE                d_hostHandle;
  char                  d_hostentbuf[ MAXGETHOSTSTRUCT ],
                        d_sessionName[ 64 ],
                        d_serverName[ 64 ],
                        d_IP[ 64 ];
  int                   d_state,
                        d_socketFlags,
                        d_serverPort,
                        d_runFlag;  // server or client communications?
  DWORD                 d_version;  // hiword is curr version.  loword is lowest supported

public:
  cComm();
  virtual ~cComm();

  int                   Init();
  int                   Startup( int mode, HWND hwnd );
  int                   Shutdown();
  HANDLE                GetHost( char *address = NULL, int port = 0 );
  SOCKET                CreateSocket();
  int                   ChangeWindows( HWND hwnd );
  int                   AddressHost();  // called after GetHost
  int                   AttemptConnect();
  int                   Disconnect();

  int                   Connected( int errmsg );

  int                   OnAsync( WPARAM wparam, LPARAM lparam );
  int                   OnGetHost( WPARAM wparam, LPARAM lparam );

  int                   ReadIntoClientQueue( cClient *pClient );
  int                   WriteFromClientQueue( cClient *pClient );

  int                   Debug();

  // meant to be overridden
  virtual long          DetermineSize( int type ) { return 0; }

  // data access methods
  inline HANDLE         GetHostHandle() const { return d_hostHandle; }
  inline SOCKET         GetSocket() const { return d_socket; }
  inline void           SetSocket( SOCKET socket ) { d_socket = socket; }
  inline void           SetState( int state ) { d_state = state; }
  inline int            GetState() { return d_state; }
  inline void           SetSessionName( char *name ) { strcpy( d_sessionName, name ); }
  inline char           *GetSessionName() { return d_sessionName; }
  inline char           *GetServerName() { return d_serverName; }
  inline char           *GetIP() { return d_IP; }
  inline void           SetPort( int port ) { d_serverPort = port; }
  inline int            GetPort() { return d_serverPort; }
};
////////////////////////////////////////////////////////////////////////////////
#endif
////////////////////////////////////////////////////////////////////////////////
// EOF /////////////////////////////////////////////////////////////////////////
