#if !defined( __CCLIENT_H )
#define __CCLIENT_H
////////////////////////////////////////////////////////////////////////////////
#if !defined( __TCLINKEDLIST_H )
#include "tcLinkedList.h"
#endif
#if !defined( __MSGQUEUE_H )
#include "cMsgQueue.h"
#endif
////////////////////////////////////////////////////////////////////////////////

class cClient {
protected:
  SOCKET                    d_socket;
  tcLinkedList<cMsgQueue>   d_msgIn,
                            d_msgOut;
  DWORD                     d_startTime;  // When did they connect?
  char                      d_name[ 32 ];
  bool                      d_receiving;
  int                       d_id;
#if defined( UDP_PROTOCOL )
  SOCKADDR                  d_address;
#endif

public:
  cClient() {
    memset( d_name, 0, sizeof( d_name ) );
    d_socket = INVALID_SOCKET;
    d_startTime = GetTickCount();
    d_receiving = 0;
    d_id = 0;
  }


  virtual ~cClient() {
    if( d_socket != INVALID_SOCKET ) {
      closesocket( d_socket );
      d_socket = INVALID_SOCKET;
    }

    while( d_msgIn.GetNext() ) {
      delete d_msgIn.GetNext();
    }
    while( d_msgOut.GetNext() ) {
      delete d_msgOut.GetNext();
    }
  }


  void AddInMsgQueue( tcLinkedList<cMsgQueue> *pQueue ) {
    tcLinkedListItterator<cMsgQueue> itter;

    for( itter = &d_msgIn; itter()->GetNext(); ++itter );
    itter()->Link( pQueue );
  }


  void AddOutMsgQueue( tcLinkedList<cMsgQueue> *pQueue ) {
    tcLinkedListItterator<cMsgQueue> itter;

    for( itter = &d_msgOut; itter()->GetNext(); ++itter );
    itter()->Link( pQueue );
  }


  inline void SetName( char *pName ) {
    if( pName ) strncpy( d_name, pName, 32 );
  }


  inline char *GetName() { return d_name; }

  inline void                    SetId( int id ) {  d_id = id;  }
  inline int                     GetId() {  return d_id;  }
  inline tcLinkedList<cMsgQueue> *GetNextMsgIn() {  return d_msgIn.GetNext();  }
  inline tcLinkedList<cMsgQueue> *GetNextMsgOut() {  return d_msgOut.GetNext();  }
  inline void                    SetSocket( SOCKET sock ) {  d_socket = sock;  }
  inline SOCKET                  GetSocket() {  return d_socket;  }
  inline void                    SetReceiving( bool receiving ) {  d_receiving = receiving;  }
  inline bool                    GetReceiving() {  return d_receiving;  }

#if defined( UDP_PROTOCOL )
  inline void                    SetAddress( SOCKADDR *pAddress ) {
    memcpy( address, pAddress, sizeof( SOCKADDR );
  }
  inline SOCKADDR                *GetAddress() {  return &d_address;  }
#endif
};


#endif

