// Lemmings - Windows CE port by Jacco Bikker, a.k.a.
// "The Phantom"  -   Intended as a demonstration of
//   EasyCE - Visit http://www.cewarez.com/coding

// --------------------------------------------------
#ifndef LEMMING_I
#define LEMMING_I

class LAnim
{
public:
	LAnim();
	~LAnim();
	void setfpos( int i, int x, int y ) { m_Fx[i] = x; m_Fy[i] = y; }
	void setsize( int x, int y ) { m_Fszx = x; m_Fszy = y; }
	void setframes( int n ) { m_Frames = n; }
	int getframes( void ) { return m_Frames; }
	void update( int x, int y, int frame );
private:
	int m_Frames;
	int m_Fx[32], m_Fy[32];
	int m_Fszx, m_Fszy;
public:
	static unsigned short* s_Frames;
};

class Lemming
{
public:
	Lemming();
	~Lemming();
	void setpos( int x, int y ) { m_X = x; m_Y = y; }
	void setanim( LAnim* a ) { m_Anim = a; }
	LAnim* getanim( void ) { return m_Anim; }
	void update( void );
	void draw( void );
	int getxpos( void ) { return m_X; }
	int getypos( void ) { return m_Y; }
	int getframe( void ) { return m_Frame; }
	void setframe( int i ) { m_Frame = i; }
	void setcounter( int i ) { m_Counter = i; }
	int getcounter( void ) { return m_Counter; }
	void isfloater( void ) { m_Floater = true; }
	void isclimber( void ) { m_Climber = true; }
	void isbomb( void ) { if (!m_Bomb) { m_Bomb = true; m_BCount = 6 * 8; } }
	bool getbomb( void ) { return m_Bomb; }
	bool getfloat( void ) { return m_Floater; }
private:
	int m_X, m_Y;
	int m_Counter, m_BCount, m_Height;
	int m_Frame;
	bool m_Floater, m_Climber, m_Bomb;
	LAnim* m_Anim;
};

#endif

// --------------------------------------------------
// EOF