#include "isInStack.h"
#include <stdio.h>

//------------------------------------------------------------------------

#define REQUIRE( A )    {if (!(A)) printf( "Assertion failed at %s(%i)\n", __FILE__, __LINE__ );}

//------------------------------------------------------------------------

class MyClass
{
};

//------------------------------------------------------------------------

static void func()
{
    char testArray[123] = {0};
    int size = usedStackSize();
    printf( "usedStackSize in %s(%i) is %i\n", __FILE__, __LINE__, size );

    REQUIRE( isInStack(&size) );
    REQUIRE( isInStack(testArray) );
}

static void test()
{
    char testArray[20] = {0};
    MyClass a;
    MyClass* b = new MyClass;
    MyClass* c = new MyClass;
    MyClass d;

    func();

    REQUIRE( isInStack(&a) );
    REQUIRE( !isInStack(b) );
    REQUIRE( !isInStack(c) );
    REQUIRE( isInStack(&d) );

    delete b;
    delete c;
}

int main()
{
    isInStackInit();
    test();
    return 0;
}
