/*
 * isInStack 1.0
 * 
 * isInStack(ptr) tests if an object pointed by ptr
 * has been created to the stack or not.
 *
 * Motivation: When doing reference counting you 
 * want to assert you're not about to delete an object
 * which has been allocated to the stack.
 *
 * Tested in following platforms:
 * - MSVC6, Win2k
 * - gcc 2.95.2, Win2k
 * - gcc 2.95.2, Linux (RedHat)
 * - gcc 2.8.1, Digital UNIX V4.0F
 *
 * Makefile and MSVC6 project files are provided.
 *
 * Known issues:
 * - I haven't given any thought how this works in a shared library (dll/so)
 * - Multithreading is supported only in Win32/MSVC
 *
 * Feb 7, 2002,
 * Jani Kajala (jani.kajala@helsinki.fi)
 * 
 * PS.  Why I didn't use !_CrtIsValidHeapPointer(p) of MSVCRT?
 *      1) portability 2) coolness factor ;)
 */
#ifndef _ISINSTACK_H
#define _ISINSTACK_H


/** 
 * Initializes isInStack.
 * The init must be called in a higher level function than
 * where the isInitStack() is actually used.
 * 
 * If multiple threads are used then the init needs to be called
 * at the beginning of each thread. Note that the thread function
 * calling isInStackInit must again be higher level than functions where
 * isInThread is actually used.
 */
void    isInStackInit();

/** 
 * Returns true if the pointed object has been created in the stack
 * of the calling thread.
 */
bool    isInStack( const void* p );

/** Returns number of bytes of stack used by the calling thread. */
int     usedStackSize();


#endif // _ISINSTACK_H
/*
 * Copyright (c) 2002 Jani Kajala
 *
 * Permission to use, copy, modify, distribute and sell this
 * software and its documentation for any purpose is hereby
 * granted without fee, provided that the above copyright notice
 * appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation.
 * Jani Kajala makes no representations about the suitability 
 * of this software for any purpose. It is provided "as is" 
 * without express or implied warranty.
 */
