// Wnd.h

#if _MSC_VER > 1000
	#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// Window creation

template <class T> T* CreateWnd(HINSTANCE hInstance, LPCTSTR szClass, 
			DWORD dwStyles, LPCTSTR szTitle = NULL, HWND hParent = NULL);

template <class T> T* CreateDlg(HINSTANCE hInstance, 
			LPCTSTR lpTemplate, HWND hParent = NULL);

/////////////////////////////////////////////////////////////////////////////
// CWnd

class CWnd
{
// Csx
public:
	CWnd() : m_hWnd(NULL)
	{
	};

// Message routing
public:

	/////////////////////////////////////////////////////////////////////////////
	// Main message handler, all derived classes must implement this func, look at usages

	virtual LRESULT CALLBACK Msg(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam) = 0;

// Message handlers
protected:

	/////////////////////////////////////////////////////////////////////////////
	// Windows message handlers, overrides (look in windowsx.h for more signatures)

	// Csx / Dsx
	virtual BOOL OnCreate(HWND hWnd, LPCREATESTRUCT lpCreateStruct) {return FALSE;};
	virtual void OnDestroy(HWND hWnd){};
	
	// Painting
	virtual void OnPaint(HWND hWnd){};
	virtual BOOL OnEraseBkgnd(HWND hWnd, HDC hDC) {return FALSE;};

	// Movement / Sizing
	virtual void OnMove(HWND hWnd, int x, int y) {};
	virtual void OnSize(HWND hWnd, UINT state, int nWidth, int nHeight){};
	virtual void OnGetMinMaxInfo(HWND hWnd, LPMINMAXINFO lpMinMaxInfo){};

	// Focus
	virtual void OnSetFocus(HWND hWnd, HWND hWndOldFocus){};
	virtual void OnKillFocus(HWND hWnd, HWND hWndNewFocus){};

	// Keyboard
	virtual void OnChar(HWND hWnd, TCHAR ch, int cRepeat){};
	virtual void OnKeyDown(HWND hWnd, UINT vk, BOOL fDown, int cRepeat, UINT flags){};

	// Mouse handlers
	virtual void OnMouseMove(HWND hWnd, int x, int y, UINT keyFlags){};
	virtual void OnLButtonDown(HWND hWnd, BOOL fDoubleClick, int x, int y, UINT keyFlags){};
	virtual void OnLButtonUp(HWND hWnd, int x, int y, UINT keyFlags){};
	virtual void OnLButtonDblClick(HWND hWnd, BOOL bDoubleClick, int x, int y, UINT keyFlags){};
	virtual void OnRButtonDown(HWND hWnd, BOOL fDoubleClick, int x, int y, UINT keyFlags){};
	virtual void OnRButtonUp(HWND hWnd, int x, int y, UINT keyFlags){};
	virtual void OnRButtonDblClick(HWND hWnd, BOOL bDoubleClick, int x, int y, UINT keyFlags){};
	virtual void OnMButtonDown(HWND hWnd, BOOL fDoubleClick, int x, int y, UINT keyFlags){};
	virtual void OnMButtonUp(HWND hWnd, int x, int y, UINT flags){};
	virtual void OnMButtonDblClick(HWND hWnd, BOOL fDoubleClick, int x, int y, UINT keyFlags){};

	// Commands
	virtual void OnCommand(HWND hWnd, int id, HWND hWndCtl, UINT codeNotify){};

	// Scrolling
	virtual void OnVScroll(HWND hWnd, HWND hCtrl, UINT uiCode, int nPos){};
	virtual void OnHScroll(HWND hWnd, HWND hCtrl, UINT uiCode, int nPos){};

// Properties
public:

	// Window handle
	HWND m_hWnd;
};

/* - Usage

// Create a picture window 	
CPicture* pPicture = CreateWnd <CPicture> (hInstance,
											szClass, 
											WS_OVERLAPPEDWINDOW | WS_VISIBLE, 
											szTitle);

LRESULT CWnd::Msg(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{ 
		HANDLE_MSG(hWnd, WM_CREATE, OnCreate);
		HANDLE_MSG(hWnd, WM_PAINT, OnPaint);
		HANDLE_MSG(hWnd, WM_SIZE, OnSize);
		HANDLE_MSG(hWnd, WM_DESTROY, OnDestroy);
		HANDLE_MSG(hWnd, WM_CLOSE, OnDestroy);
		HANDLE_MSG(hWnd, WM_COMMAND, OnCommand);

		default:
			return (DefWindowProc(hWnd, uMsg, wParam, lParam));
	}
}
*/

/////////////////////////////////////////////////////////////////////////////
// CDialog

class CDialog : public CWnd
{	
// Message handlers
protected:

	// Initialization
	virtual BOOL OnInitDialog(HWND hWnd, HWND hWndFocus, LPARAM lParam) {return TRUE;};
};

/* - Usage

CPicture* pPicture = CreateDlg <CPicture> (hInstance,
												MAKEINTRESOURCE(IDD_PICTURE));

LRESULT CDialog::Msg(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{ 
		HANDLE_MSG(hWnd, WM_INITDIALOG, OnInitDialog);
		HANDLE_MSG(hWnd, WM_PAINT, OnPaint);
		HANDLE_MSG(hWnd, WM_COMMAND, OnCommand);

		default:
			return FALSE; // Dialogs do no call DefWindowProc()
	}
}
*/

/////////////////////////////////////////////////////////////////////////////
// Message routing support

typedef std::map<HWND, CWnd*> CWndMap;
typedef std::map<HWND, CWnd*>::iterator iWnd;

/////////////////////////////////////////////////////////////////////////////
// Macros for derived window classes

#define DECLARE_WINDOW_CLASS(T)\
class T;\
template T* CreateWnd <T> (HINSTANCE hInstance, LPCTSTR szClass, \
	DWORD dwStyles, LPCTSTR szTitle /* = NULL */, HWND hParent /* = NULL */); \

#define DECLARE_DIALOG_CLASS(T)\
class T;\
template T* CreateDlg <T> (HINSTANCE hInstance, \
	LPCTSTR lpTemplate, HWND hParent /*= NULL*/); \

/////////////////////////////////////////////////////////////////////////////
// Diagnostics

void DumpHandleMap();