// Picture.cpp

#include "stdafx.h"
#include "wnds.h"

/////////////////////////////////////////////////////////////////////////////
// Message routing

LRESULT CPicture::Msg(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{ 
		HANDLE_MSG(hWnd, WM_CREATE, OnCreate);
		HANDLE_MSG(hWnd, WM_PAINT, OnPaint);
		HANDLE_MSG(hWnd, WM_SIZE, OnSize);
		HANDLE_MSG(hWnd, WM_CLOSE, OnDestroy);

		default:
			return (DefWindowProc(hWnd, uMsg, wParam, lParam));
	}
}

/////////////////////////////////////////////////////////////////////////////
// Message handlers

BOOL CPicture::OnCreate(HWND hWnd, LPCREATESTRUCT lpCreateStruct)
{
	// Load it
	m_hPixmap = (HBITMAP)LoadImage(NULL, 
		_T("./data/lucy.bmp"), 
		IMAGE_BITMAP, 
		0, 0, 
		LR_LOADFROMFILE | LR_DEFAULTSIZE);

	if(!m_hPixmap)
		return FALSE;

	// Get dimensions of the bitmap
	BITMAP bmp;
	ZERO(bmp, BITMAP)
	GetObject(m_hPixmap, sizeof(BITMAP), &bmp);

	// Set the demensions
	m_sizePixmap.cx = bmp.bmWidth;
	m_sizePixmap.cy = bmp.bmHeight;

	// Size window to pixmap
	RECT rectAdjust;
	SetRectEmpty(&rectAdjust);
	rectAdjust.right = m_sizePixmap.cx;
	rectAdjust.bottom = m_sizePixmap.cy;
	AdjustWindowRect(&rectAdjust, WS_OVERLAPPEDWINDOW | WS_VISIBLE, FALSE);
	SetWindowPos(hWnd, 0, 0, 0, WIDTH(rectAdjust), HEIGHT(rectAdjust), SWP_NOMOVE);

	return FALSE;
}

// Painting
void CPicture::OnPaint(HWND hWnd)
{
	// Client rectangle
	RECT rectClient;
	GetClientRect(hWnd, &rectClient);

	PAINTSTRUCT ps;
    HDC hDC = BeginPaint(hWnd, &ps);

	// Cache DC
	int nOldDC = SaveDC(hDC);

	HDC hMemDC = CreateCompatibleDC(hDC);
	SelectObject(hMemDC, m_hPixmap);

	// StretchBlt
	StretchBlt(hDC, 
		rectClient.left, 
		rectClient.top,
		WIDTH(rectClient), 
		HEIGHT(rectClient),
		hMemDC, 
		0,
		0, 
		m_sizePixmap.cx, 
		m_sizePixmap.cy, 
		SRCCOPY);

	RestoreDC(hDC, nOldDC);
	DeleteDC(hMemDC);
    EndPaint(hWnd, &ps);
}

// Movement
void CPicture::OnSize(HWND hWnd, UINT state, int nWidth, int nHeight)
{
	// Redraw the pixmap
	InvalidateRect(hWnd, NULL, FALSE);
}

void CPicture::OnDestroy(HWND hWnd)
{
	// Clean up..
	DeleteBitmap(m_hPixmap);

	// Exit application
	PostQuitMessage(0);
}